/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.routing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;

public class Route {
    private static final String VERSION_MISMATCH = "Prefix and next hop must be in the same address family";
    private final Source source;
    private final IpPrefix prefix;
    private final IpAddress nextHop;

    public Route(Source source, IpPrefix prefix, IpAddress nextHop) {
        Preconditions.checkNotNull((Object)prefix);
        Preconditions.checkNotNull((Object)nextHop);
        Preconditions.checkArgument((boolean)prefix.version().equals((Object)nextHop.version()), (Object)VERSION_MISMATCH);
        this.source = (Source)((Object)Preconditions.checkNotNull((Object)((Object)source)));
        this.prefix = prefix;
        this.nextHop = nextHop;
    }

    public Source source() {
        return this.source;
    }

    public IpPrefix prefix() {
        return this.prefix;
    }

    public IpAddress nextHop() {
        return this.nextHop;
    }

    public int hashCode() {
        return Objects.hash(this.prefix, this.nextHop);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Route)) {
            return false;
        }
        Route that = (Route)other;
        return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.nextHop, that.nextHop);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("prefix", (Object)this.prefix).add("nextHop", (Object)this.nextHop).toString();
    }

    public static enum Source {
        BGP,
        FPM,
        STATIC,
        UNDEFINED;

    }
}

