/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.routing;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.incubator.net.routing.NextHopData;
import org.onosproject.net.ConnectPoint;

public class NextHop {
    private final IpAddress ip;
    private final NextHopData nextHopData;

    public NextHop(IpAddress ip, NextHopData nextHopData) {
        this.ip = ip;
        this.nextHopData = nextHopData;
    }

    public IpAddress ip() {
        return this.ip;
    }

    public MacAddress mac() {
        return this.nextHopData.mac();
    }

    public ConnectPoint location() {
        return this.nextHopData.location();
    }

    public int hashCode() {
        return Objects.hash(this.ip, this.nextHopData);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NextHop)) {
            return false;
        }
        NextHop that = (NextHop)other;
        return Objects.equals(this.ip, that.ip) && Objects.equals(this.nextHopData, that.nextHopData);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ip", (Object)this.ip).add("nextHopData", (Object)this.nextHopData).toString();
    }
}

