/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.resource.label;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.onosproject.incubator.net.resource.label.LabelResource;
import org.onosproject.net.DeviceId;

@Beta
public class LabelResourceRequest {
    private final DeviceId deviceId;
    private final Type type;
    private final long applyNum;
    private ImmutableSet<LabelResource> releaseCollection;

    public LabelResourceRequest(DeviceId deviceId, Type type, long applyNum, ImmutableSet<LabelResource> releaseCollection) {
        this.deviceId = deviceId;
        this.type = type;
        this.applyNum = applyNum;
        this.releaseCollection = releaseCollection;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public Type type() {
        return this.type;
    }

    public long applyNum() {
        return this.applyNum;
    }

    public Collection<LabelResource> releaseCollection() {
        return this.releaseCollection;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.applyNum, this.type, this.releaseCollection});
    }

    public boolean equals(Object obj) {
        if (obj instanceof LabelResourceRequest) {
            LabelResourceRequest that = (LabelResourceRequest)obj;
            return Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.applyNum, that.applyNum) && Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.releaseCollection, that.releaseCollection);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId).add("applyNum", this.applyNum).add("type", (Object)this.type).add("releaseCollection", this.releaseCollection).toString();
    }

    public static enum Type {
        APPLY,
        RELEASE;

    }
}

