/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.resource.label;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.onosproject.incubator.net.resource.label.LabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.net.DeviceId;

@Beta
public class LabelResourcePool {
    private final DeviceId deviceId;
    private final LabelResourceId beginLabel;
    private final LabelResourceId endLabel;
    private final long totalNum;
    private final long usedNum;
    private final LabelResourceId currentUsedMaxLabelId;
    private ImmutableSet<LabelResource> releaseLabelId;

    public LabelResourcePool(String deviceId, long beginLabel, long endLabel) {
        this(deviceId, beginLabel, endLabel, endLabel - beginLabel + 1L, 0L, beginLabel, (ImmutableSet<LabelResource>)ImmutableSet.copyOf(Collections.emptySet()));
    }

    public LabelResourcePool(String deviceId, long beginLabel, long endLabel, long totalNum, long usedNum, long currentUsedMaxLabelId, ImmutableSet<LabelResource> releaseLabelId) {
        Preconditions.checkArgument((endLabel >= beginLabel ? 1 : 0) != 0, (String)"endLabel %s must be greater than or equal to beginLabel %s", (long)endLabel, (long)beginLabel);
        this.deviceId = DeviceId.deviceId((String)deviceId);
        this.beginLabel = LabelResourceId.labelResourceId(beginLabel);
        this.endLabel = LabelResourceId.labelResourceId(endLabel);
        this.totalNum = totalNum;
        this.usedNum = usedNum;
        this.currentUsedMaxLabelId = LabelResourceId.labelResourceId(currentUsedMaxLabelId);
        this.releaseLabelId = releaseLabelId;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public LabelResourceId beginLabel() {
        return this.beginLabel;
    }

    public LabelResourceId endLabel() {
        return this.endLabel;
    }

    public LabelResourceId currentUsedMaxLabelId() {
        return this.currentUsedMaxLabelId;
    }

    public long totalNum() {
        return this.totalNum;
    }

    public long usedNum() {
        return this.usedNum;
    }

    public Set<LabelResource> releaseLabelId() {
        return this.releaseLabelId;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.beginLabel, this.endLabel, this.totalNum, this.usedNum, this.currentUsedMaxLabelId, this.releaseLabelId});
    }

    public boolean equals(Object obj) {
        if (obj instanceof LabelResourcePool) {
            LabelResourcePool that = (LabelResourcePool)obj;
            return Objects.equals(this.deviceId, that.deviceId) && Objects.equals((Object)this.beginLabel, (Object)that.beginLabel) && Objects.equals((Object)this.endLabel, (Object)that.endLabel) && Objects.equals(this.totalNum, that.totalNum) && Objects.equals(this.usedNum, that.usedNum) && Objects.equals((Object)this.currentUsedMaxLabelId, (Object)that.currentUsedMaxLabelId) && Objects.equals(this.releaseLabelId, that.releaseLabelId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("deviceId", (Object)this.deviceId).add("beginLabel", (Object)this.beginLabel).add("endLabel", (Object)this.endLabel).add("totalNum", this.totalNum).add("usedNum", this.usedNum).add("currentUsedMaxLabelId", (Object)this.currentUsedMaxLabelId).add("releaseLabelId", this.releaseLabelId).toString();
    }
}

