/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.neighbour;

import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.incubator.net.neighbour.NeighbourMessageContext;
import org.onosproject.incubator.net.neighbour.NeighbourMessageHandler;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostService;

public class DefaultNeighbourMessageHandler
implements NeighbourMessageHandler {
    @Override
    public void handleMessage(NeighbourMessageContext context, HostService hostService) {
        switch (context.type()) {
            case REPLY: {
                Host h = hostService.getHost(HostId.hostId((MacAddress)context.packet().getDestinationMAC(), (VlanId)VlanId.vlanId((short)context.packet().getVlanID())));
                if (h == null) {
                    context.flood();
                    break;
                }
                context.forward((ConnectPoint)h.location());
                break;
            }
            case REQUEST: {
                Set hosts = hostService.getHostsByIp(context.target());
                Host dst = null;
                Host src = hostService.getHost(HostId.hostId((MacAddress)context.srcMac(), (VlanId)context.vlan()));
                for (Host host : hosts) {
                    if (!host.vlan().equals((Object)context.vlan())) continue;
                    dst = host;
                    break;
                }
                if (src != null && dst != null) {
                    context.reply(dst.mac());
                    return;
                }
                context.flood();
                break;
            }
        }
    }
}

