/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.faultmanagement.alarm;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.incubator.net.faultmanagement.alarm.Alarm;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmEntityId;
import org.onosproject.incubator.net.faultmanagement.alarm.AlarmId;
import org.onosproject.net.DeviceId;

public final class DefaultAlarm
implements Alarm {
    private final AlarmId id;
    private final DeviceId deviceId;
    private final String description;
    private final AlarmEntityId source;
    private final long timeRaised;
    private final boolean isServiceAffecting;
    private final boolean isAcknowledged;
    private final boolean isManuallyClearable;
    private final String assignedUser;
    private final Alarm.SeverityLevel severity;
    private final long timeUpdated;
    private final Long timeCleared;

    DefaultAlarm() {
        this.id = null;
        this.deviceId = null;
        this.description = null;
        this.source = null;
        this.timeRaised = -1L;
        this.timeUpdated = -1L;
        this.timeCleared = null;
        this.severity = null;
        this.isServiceAffecting = false;
        this.isAcknowledged = false;
        this.isManuallyClearable = false;
        this.assignedUser = null;
    }

    private DefaultAlarm(AlarmId id, DeviceId deviceId, String description, AlarmEntityId source, long timeRaised, long timeUpdated, Long timeCleared, Alarm.SeverityLevel severity, boolean isServiceAffecting, boolean isAcknowledged, boolean isManuallyClearable, String assignedUser) {
        this.id = id;
        this.deviceId = deviceId;
        this.description = description;
        this.source = source;
        this.timeRaised = timeRaised;
        this.timeUpdated = timeUpdated;
        this.timeCleared = timeCleared;
        this.severity = severity;
        this.isServiceAffecting = isServiceAffecting;
        this.isAcknowledged = isAcknowledged;
        this.isManuallyClearable = isManuallyClearable;
        this.assignedUser = assignedUser;
    }

    @Override
    public AlarmId id() {
        return this.id;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public AlarmEntityId source() {
        return this.source;
    }

    @Override
    public long timeRaised() {
        return this.timeRaised;
    }

    @Override
    public long timeUpdated() {
        return this.timeUpdated;
    }

    @Override
    public Long timeCleared() {
        return this.timeCleared;
    }

    @Override
    public Alarm.SeverityLevel severity() {
        return this.severity;
    }

    @Override
    public boolean serviceAffecting() {
        return this.isServiceAffecting;
    }

    @Override
    public boolean acknowledged() {
        return this.isAcknowledged;
    }

    @Override
    public boolean cleared() {
        return this.severity.equals((Object)Alarm.SeverityLevel.CLEARED);
    }

    @Override
    public boolean manuallyClearable() {
        return this.isManuallyClearable;
    }

    @Override
    public String assignedUser() {
        return this.assignedUser;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deviceId, this.description, this.source, this.timeCleared, this.severity, this.isServiceAffecting, this.isAcknowledged, this.isManuallyClearable, this.assignedUser});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultAlarm other = (DefaultAlarm)obj;
        if (!Objects.equals(this.deviceId, other.deviceId)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals((Object)this.source, (Object)other.source)) {
            return false;
        }
        if (!Objects.equals(this.timeCleared, other.timeCleared)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.isServiceAffecting != other.isServiceAffecting) {
            return false;
        }
        if (this.isAcknowledged != other.isAcknowledged) {
            return false;
        }
        if (this.isManuallyClearable != other.isManuallyClearable) {
            return false;
        }
        return Objects.equals(this.assignedUser, other.assignedUser);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("deviceId", (Object)this.deviceId).add("description", (Object)this.description).add("source", (Object)this.source).add("timeRaised", this.timeRaised).add("timeUpdated", this.timeUpdated).add("timeCleared", (Object)this.timeCleared).add("severity", (Object)this.severity).add("serviceAffecting", this.isServiceAffecting).add("acknowledged", this.isAcknowledged).add("manuallyClearable", this.isManuallyClearable).add("assignedUser", (Object)this.assignedUser).toString();
    }

    public static class Builder {
        private AlarmId id;
        private final DeviceId deviceId;
        private final String description;
        private Alarm.SeverityLevel severity;
        private final long timeRaised;
        private AlarmEntityId source = AlarmEntityId.NONE;
        private long timeUpdated;
        private Long timeCleared = null;
        private boolean isServiceAffecting = false;
        private boolean isAcknowledged = false;
        private boolean isManuallyClearable = false;
        private String assignedUser = null;

        public Builder(Alarm alarm) {
            this(alarm.id(), alarm.deviceId(), alarm.description(), alarm.severity(), alarm.timeRaised());
            this.source = alarm.source();
            this.timeUpdated = alarm.timeUpdated();
            this.timeCleared = alarm.timeCleared();
            this.isServiceAffecting = alarm.serviceAffecting();
            this.isAcknowledged = alarm.acknowledged();
            this.isManuallyClearable = alarm.manuallyClearable();
            this.assignedUser = alarm.assignedUser();
        }

        @Deprecated
        public Builder(DeviceId deviceId, String description, Alarm.SeverityLevel severity, long timeRaised) {
            this.deviceId = deviceId;
            this.description = description;
            this.severity = severity;
            this.timeRaised = timeRaised;
            this.timeUpdated = timeRaised;
            this.id = AlarmId.alarmId(deviceId, Long.toString(timeRaised));
        }

        public Builder(AlarmId id, DeviceId deviceId, String description, Alarm.SeverityLevel severity, long timeRaised) {
            this.id = id;
            this.deviceId = deviceId;
            this.description = description;
            this.severity = severity;
            this.timeRaised = timeRaised;
            this.timeUpdated = timeRaised;
        }

        public Builder forSource(AlarmEntityId source) {
            this.source = source;
            return this;
        }

        public Builder withTimeUpdated(long timeUpdated) {
            this.timeUpdated = timeUpdated;
            return this;
        }

        public Builder withTimeCleared(Long timeCleared) {
            this.timeCleared = timeCleared;
            return this;
        }

        @Deprecated
        public Builder withId(AlarmId id) {
            this.id = id;
            return this;
        }

        public Builder clear() {
            this.severity = Alarm.SeverityLevel.CLEARED;
            long now = System.currentTimeMillis();
            return this.withTimeCleared(now).withTimeUpdated(now);
        }

        public Builder withServiceAffecting(boolean isServiceAffecting) {
            this.isServiceAffecting = isServiceAffecting;
            return this;
        }

        public Builder withAcknowledged(boolean isAcknowledged) {
            this.isAcknowledged = isAcknowledged;
            return this;
        }

        public Builder withManuallyClearable(boolean isManuallyClearable) {
            this.isManuallyClearable = isManuallyClearable;
            return this;
        }

        public Builder withAssignedUser(String assignedUser) {
            this.assignedUser = assignedUser;
            return this;
        }

        public DefaultAlarm build() {
            Preconditions.checkNotNull((Object)((Object)this.id), (Object)"Must specify an alarm id");
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"Must specify a device");
            Preconditions.checkNotNull((Object)this.description, (Object)"Must specify a description");
            Preconditions.checkNotNull((Object)this.timeRaised, (Object)"Must specify a time raised");
            Preconditions.checkNotNull((Object)this.timeUpdated, (Object)"Must specify a time updated");
            Preconditions.checkNotNull((Object)((Object)this.severity), (Object)"Must specify a severity");
            return new DefaultAlarm(this.id, this.deviceId, this.description, this.source, this.timeRaised, this.timeUpdated, this.timeCleared, this.severity, this.isServiceAffecting, this.isAcknowledged, this.isManuallyClearable, this.assignedUser);
        }
    }
}

