/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.faultmanagement.alarm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.onlab.util.Identifier;

public final class AlarmEntityId
extends Identifier<URI> {
    public static final AlarmEntityId NONE = new AlarmEntityId(URI.create("none:none"));
    public static final Set<String> SCHEMES = ImmutableSet.of((Object)"none", (Object)"port", (Object)"och", (Object)"other");

    private AlarmEntityId(URI uri) {
        super((Object)uri);
    }

    protected AlarmEntityId() {
        super(AlarmEntityId.NONE.identifier);
    }

    public static AlarmEntityId alarmEntityId(String string) {
        return AlarmEntityId.alarmEntityId(URI.create(string));
    }

    public static AlarmEntityId alarmEntityId(URI uri) {
        Preconditions.checkArgument((boolean)SCHEMES.contains(uri.getScheme()), (Object)"Unexpected scheme");
        return new AlarmEntityId(uri);
    }
}

