/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.dpi;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.dpi.TrafficStatInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrafficStatInfoCodec
extends JsonCodec<TrafficStatInfo> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ObjectNode encode(TrafficStatInfo tsi, CodecContext context) {
        Preconditions.checkNotNull((Object)tsi, (Object)"TrafficStatInfo cannot be null");
        return context.mapper().createObjectNode().put("ethernetBytes", tsi.ethernetBytes()).put("discardedBytes", tsi.discardedBytes()).put("ipPackets", tsi.ipPackets()).put("totalPackets", tsi.totalPackets()).put("ipBytes", tsi.ipBytes()).put("avgPktSize", tsi.avgPktSize()).put("uniqueFlows", tsi.uniqueFlows()).put("tcpPackets", tsi.tcpPackets()).put("udpPackets", tsi.udpPackets()).put("dpiThroughputPps", tsi.dpiThroughputPps()).put("dpiThroughputBps", tsi.dpiThroughputBps()).put("trafficThroughputPps", tsi.trafficThroughputPps()).put("trafficThroughputBps", tsi.trafficThroughputBps()).put("trafficDurationSec", tsi.trafficDurationSec()).put("guessedFlowProtos", tsi.guessedFlowProtos());
    }

    public TrafficStatInfo decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        this.log.debug("ethernetBytes={}, full json={} ", (Object)json.get("ethernetBytes"), (Object)json);
        Long ethernetBytes = json.get("ethernetBytes").asLong();
        Long discardedBytes = json.get("discardedBytes").asLong();
        Long ipPackets = json.get("ipPackets").asLong();
        Long totalPackets = json.get("totalPackets").asLong();
        Long ipBytes = json.get("ipBytes").asLong();
        int avgPktSize = json.get("avgPktSize").asInt();
        int uniqueFlows = json.get("uniqueFlows").asInt();
        Long tcpPackets = json.get("tcpPackets").asLong();
        Long udpPackets = json.get("udpPackets").asLong();
        double dpiThroughputPps = json.get("dpiThroughputPps").asDouble();
        double dpiThroughputBps = json.get("dpiThroughputBps").asDouble();
        double trafficThroughputPps = json.get("trafficThroughputPps").asDouble();
        double trafficThroughputBps = json.get("trafficThroughputBps").asDouble();
        double trafficDurationSec = json.get("trafficDurationSec").asDouble();
        int guessedFlowProtos = json.get("guessedFlowProtos").asInt();
        return new TrafficStatInfo(ethernetBytes, discardedBytes, ipPackets, totalPackets, ipBytes, avgPktSize, uniqueFlows, tcpPackets, udpPackets, dpiThroughputPps, dpiThroughputBps, trafficThroughputPps, trafficThroughputBps, trafficDurationSec, guessedFlowProtos);
    }
}

