/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.dpi;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.dpi.ProtocolStatInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProtocolStatInfoCodec
extends JsonCodec<ProtocolStatInfo> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ObjectNode encode(ProtocolStatInfo psi, CodecContext context) {
        Preconditions.checkNotNull((Object)psi, (Object)"ProtocolStatInfo cannot be null");
        return context.mapper().createObjectNode().put("name", psi.name()).put("breed", psi.breed()).put("packets", psi.packets()).put("bytes", psi.bytes()).put("flows", psi.flows());
    }

    public ProtocolStatInfo decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        this.log.debug("name={}, full json={} ", (Object)json.get("name"), (Object)json);
        String name = json.get("name").asText();
        String breed = json.get("breed").asText();
        long packets = json.get("packets").asLong();
        long bytes = json.get("bytes").asLong();
        int flows = json.get("flows").asInt();
        return new ProtocolStatInfo(name, breed, packets, bytes, flows);
    }
}

