/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.dpi;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.dpi.FlowStatInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FlowStatInfoCodec
extends JsonCodec<FlowStatInfo> {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ObjectNode encode(FlowStatInfo fsi, CodecContext context) {
        Preconditions.checkNotNull((Object)fsi, (Object)"FlowStatInfo cannot be null");
        return context.mapper().createObjectNode().put("protocol", fsi.protocol()).put("hostAName", fsi.hostAName()).put("hostAPort", fsi.hostAPort()).put("hostBName", fsi.hostBName()).put("hostBPort", fsi.hostBPort()).put("detectedProtocol", fsi.detectedProtocol()).put("detectedProtocolName", fsi.detectedProtocolName()).put("packets", fsi.packets()).put("bytes", fsi.bytes()).put("hostServerName", fsi.hostServerName());
    }

    public FlowStatInfo decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        this.log.debug("protocol={}, full json={} ", (Object)json.get("protocol"), (Object)json);
        String protocol = json.get("protocol").asText();
        String hostAName = json.get("hostAName").asText();
        int hostAPort = json.get("hostAPort").asInt();
        String hostBName = json.get("hostBName").asText();
        int hostBPort = json.get("hostBPort").asInt();
        int detectedProtocol = json.get("detectedProtocol").asInt();
        String detectedProtocolName = json.get("detectedProtocolName").asText();
        long packets = json.get("packets").asLong();
        long bytes = json.get("bytes").asLong();
        String hostServerName = json.get("hostServerName").asText();
        return new FlowStatInfo(protocol, hostAName, hostAPort, hostBName, hostBPort, detectedProtocol, detectedProtocolName, packets, bytes, hostServerName);
    }
}

