/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.dpi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.dpi.DpiStatInfo;
import org.onosproject.incubator.net.dpi.DpiStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DpiStatisticsCodec
extends JsonCodec<DpiStatistics> {
    private static final String RECEIVED_TIME = "receivedTime";
    private static final String DPI_STATISTICS = "dpiStatistics";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ObjectNode encode(DpiStatistics ds, CodecContext context) {
        Preconditions.checkNotNull((Object)ds, (Object)"DpiStatistics cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        result.put(RECEIVED_TIME, ds.receivedTime());
        JsonCodec dpiStatInfoCodec = context.codec(DpiStatInfo.class);
        ObjectNode jsonDpiStatInfo = dpiStatInfoCodec.encode((Object)ds.dpiStatInfo(), context);
        result.set(DPI_STATISTICS, (JsonNode)jsonDpiStatInfo);
        return result;
    }

    public DpiStatistics decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        this.log.debug("receivedTime={}, full json={} ", (Object)json.get(RECEIVED_TIME), (Object)json);
        JsonNode receivedTimeJson = json.get(RECEIVED_TIME);
        String receivedTime = receivedTimeJson == null ? "" : receivedTimeJson.asText();
        JsonCodec dpiStatInfoCodec = context.codec(DpiStatInfo.class);
        DpiStatInfo dpiStatInfo = (DpiStatInfo)dpiStatInfoCodec.decode(DpiStatisticsCodec.get((ObjectNode)json, (String)DPI_STATISTICS), context);
        return new DpiStatistics(receivedTime, dpiStatInfo);
    }
}

