/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.incubator.net.dpi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.incubator.net.dpi.DpiStatInfo;
import org.onosproject.incubator.net.dpi.FlowStatInfo;
import org.onosproject.incubator.net.dpi.ProtocolStatInfo;
import org.onosproject.incubator.net.dpi.TrafficStatInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DpiStatInfoCodec
extends JsonCodec<DpiStatInfo> {
    private static final String TRAFFIC_STATISTICS = "trafficStatistics";
    private static final String DETECTED_PROTOS = "detectedProtos";
    private static final String KNOWN_FLOWS = "knownFlows";
    private static final String UNKNOWN_FLOWS = "unknownFlows";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public ObjectNode encode(DpiStatInfo dsi, CodecContext context) {
        JsonCodec flowStatInfoCodec;
        List<FlowStatInfo> fsi;
        List<ProtocolStatInfo> psi;
        Preconditions.checkNotNull((Object)dsi, (Object)"DpiStatInfo cannot be null");
        ObjectNode result = context.mapper().createObjectNode();
        JsonCodec trafficStatInfoCodec = context.codec(TrafficStatInfo.class);
        TrafficStatInfo tsi = dsi.trafficStatistics();
        if (tsi != null) {
            ObjectNode jsonTrafficStatistics = trafficStatInfoCodec.encode((Object)tsi, context);
            result.set(TRAFFIC_STATISTICS, (JsonNode)jsonTrafficStatistics);
        }
        if ((psi = dsi.detectedProtos()) != null) {
            ArrayNode jsonDetectedProtos = result.putArray(DETECTED_PROTOS);
            JsonCodec protocolStatInfoCodec = context.codec(ProtocolStatInfo.class);
            for (ProtocolStatInfo protocolStatInfo : psi) {
                jsonDetectedProtos.add((JsonNode)protocolStatInfoCodec.encode((Object)protocolStatInfo, context));
            }
        }
        if ((fsi = dsi.knownFlows()) != null) {
            ArrayNode jsonKnownFlows = result.putArray(KNOWN_FLOWS);
            flowStatInfoCodec = context.codec(FlowStatInfo.class);
            for (FlowStatInfo flowStatInfo : fsi) {
                jsonKnownFlows.add((JsonNode)flowStatInfoCodec.encode((Object)flowStatInfo, context));
            }
        }
        if ((fsi = dsi.unknownFlows()) != null) {
            ArrayNode jsonUnknownFlows = result.putArray(UNKNOWN_FLOWS);
            flowStatInfoCodec = context.codec(FlowStatInfo.class);
            for (FlowStatInfo flowStatInfo : fsi) {
                jsonUnknownFlows.add((JsonNode)flowStatInfoCodec.encode((Object)flowStatInfo, context));
            }
        }
        return result;
    }

    public DpiStatInfo decode(ObjectNode json, CodecContext context) {
        if (json == null || !json.isObject()) {
            return null;
        }
        this.log.debug("trafficStatistics={}, full json={} ", (Object)json.get(TRAFFIC_STATISTICS), (Object)json);
        TrafficStatInfo trafficStatInfo = null;
        ObjectNode tsJson = DpiStatInfoCodec.get((ObjectNode)json, (String)TRAFFIC_STATISTICS);
        if (tsJson != null) {
            JsonCodec trafficStatInfoJsonCodec = context.codec(TrafficStatInfo.class);
            trafficStatInfo = (TrafficStatInfo)trafficStatInfoJsonCodec.decode(tsJson, context);
        }
        JsonCodec protocolStatInfoCodec = context.codec(ProtocolStatInfo.class);
        ArrayList<ProtocolStatInfo> detectedProtos = new ArrayList<ProtocolStatInfo>();
        JsonNode dpJson = json.get(DETECTED_PROTOS);
        if (dpJson != null) {
            IntStream.range(0, dpJson.size()).forEach(i -> detectedProtos.add((ProtocolStatInfo)protocolStatInfoCodec.decode(DpiStatInfoCodec.get((JsonNode)dpJson, (int)i), context)));
        }
        JsonCodec flowStatInfoCodec = context.codec(FlowStatInfo.class);
        ArrayList<FlowStatInfo> knownFlows = new ArrayList<FlowStatInfo>();
        JsonNode kfJson = json.get(KNOWN_FLOWS);
        if (kfJson != null) {
            IntStream.range(0, kfJson.size()).forEach(i -> knownFlows.add((FlowStatInfo)flowStatInfoCodec.decode(DpiStatInfoCodec.get((JsonNode)kfJson, (int)i), context)));
        }
        ArrayList<FlowStatInfo> unknownFlows = new ArrayList<FlowStatInfo>();
        JsonNode ufJson = json.get(UNKNOWN_FLOWS);
        if (ufJson != null) {
            IntStream.range(0, ufJson.size()).forEach(i -> unknownFlows.add((FlowStatInfo)flowStatInfoCodec.decode(DpiStatInfoCodec.get((JsonNode)ufJson, (int)i), context)));
        }
        return new DpiStatInfo(trafficStatInfo, detectedProtos, knownFlows, unknownFlows);
    }
}

