/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.model.LeafListKey;
import org.onosproject.yang.model.ListKey;
import org.onosproject.yang.model.ModelException;
import org.onosproject.yang.model.NodeKey;

public class ResourceId {
    private List<NodeKey> nodeKeyList;

    public ResourceId(Builder builder) {
        this.nodeKeyList = builder.nodeKeyList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<NodeKey> nodeKeys() {
        return this.nodeKeyList;
    }

    public Builder copyBuilder() throws CloneNotSupportedException {
        return new Builder(this);
    }

    public int hashCode() {
        return Objects.hash(this.nodeKeyList);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ResourceId that = (ResourceId)obj;
        List<NodeKey> thatList = that.nodeKeyList;
        return this.nodeKeyList.size() == thatList.size() && this.nodeKeyList.containsAll(thatList);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("nodeKeyList", this.nodeKeyList).toString();
    }

    public static class Builder {
        protected Object appInfo;
        protected List<NodeKey> nodeKeyList = new LinkedList<NodeKey>();
        protected NodeKey.NodeKeyBuilder curKeyBuilder;

        public Builder() {
        }

        public Builder(ResourceId id) throws CloneNotSupportedException {
            for (NodeKey key : id.nodeKeyList) {
                this.nodeKeyList.add(key.clone());
            }
        }

        public Builder append(ResourceId id) throws CloneNotSupportedException {
            this.processCurKey();
            this.curKeyBuilder = null;
            Builder ob = id.copyBuilder();
            this.nodeKeyList.addAll(ob.nodeKeyList);
            return this;
        }

        protected void processCurKey() {
            if (this.curKeyBuilder != null) {
                if (this.curKeyBuilder instanceof LeafListKey.LeafListKeyBuilder) {
                    throw new ModelException("Leaf must be the terminal node");
                }
                this.nodeKeyList.add(this.curKeyBuilder.build());
            }
        }

        public Builder addBranchPointSchema(String name, String nameSpace) {
            this.processCurKey();
            this.curKeyBuilder = new NodeKey.NodeKeyBuilder();
            this.curKeyBuilder.schemaId(name, nameSpace);
            return this;
        }

        public Builder addLeafListBranchPoint(String name, String nameSpace, Object val) {
            if (this.curKeyBuilder instanceof LeafListKey.LeafListKeyBuilder) {
                throw new ModelException("Leaf list is not a key of list");
            }
            LeafListKey.LeafListKeyBuilder leafListKeyBuilder = ((LeafListKey.LeafListKeyBuilder)new LeafListKey.LeafListKeyBuilder().schemaId(name, nameSpace)).value(val);
            this.processCurKey();
            this.curKeyBuilder = leafListKeyBuilder;
            return this;
        }

        public Builder addKeyLeaf(String name, String nameSpace, Object val) {
            ListKey.ListKeyBuilder listKeyBuilder;
            if (!(this.curKeyBuilder instanceof ListKey.ListKeyBuilder)) {
                if (this.curKeyBuilder instanceof LeafListKey.LeafListKeyBuilder) {
                    throw new ModelException("Leaf must be the terminal node");
                }
                listKeyBuilder = new ListKey.ListKeyBuilder(this.curKeyBuilder);
            } else {
                listKeyBuilder = (ListKey.ListKeyBuilder)this.curKeyBuilder;
            }
            listKeyBuilder.addKeyLeaf(name, nameSpace, val);
            this.curKeyBuilder = listKeyBuilder;
            return this;
        }

        public ResourceId build() {
            if (this.curKeyBuilder != null) {
                this.nodeKeyList.add(this.curKeyBuilder.build());
                this.curKeyBuilder = null;
            }
            return new ResourceId(this);
        }

        public Builder removeLastKey() {
            this.nodeKeyList.remove(this.nodeKeyList.size() - 1);
            return this;
        }

        public Object appInfo() {
            return this.appInfo;
        }

        public void appInfo(Object appInfo) {
            this.appInfo = appInfo;
        }
    }
}

