/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.yang.model.SchemaId;

public class NodeKey<E extends NodeKey>
implements Comparable<E>,
Cloneable {
    protected SchemaId schemaId;

    protected NodeKey(NodeKeyBuilder builder) {
        this.schemaId = builder.schemaId;
    }

    public static NodeKeyBuilder builder() {
        return new NodeKeyBuilder();
    }

    public SchemaId schemaId() {
        return this.schemaId;
    }

    @Override
    public int compareTo(NodeKey o) {
        Preconditions.checkNotNull((Object)o);
        return this.schemaId.compareTo(o.schemaId());
    }

    public int hashCode() {
        return Objects.hash(this.schemaId);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        NodeKey that = (NodeKey)obj;
        return Objects.equals(this.schemaId, that.schemaId);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("schemaId", (Object)this.schemaId).toString();
    }

    public NodeKey clone() throws CloneNotSupportedException {
        NodeKey clonedKey = (NodeKey)super.clone();
        clonedKey.schemaId = this.schemaId.clone();
        return clonedKey;
    }

    public static class NodeKeyBuilder<B extends NodeKeyBuilder<B>> {
        private SchemaId schemaId;

        public NodeKeyBuilder() {
        }

        protected NodeKeyBuilder(NodeKeyBuilder base) {
            Preconditions.checkNotNull((Object)base.schemaId, (Object)"Schema info is not complete");
            this.schemaId = base.schemaId;
        }

        public B schemaId(SchemaId schema) {
            this.schemaId = schema;
            return (B)this;
        }

        public B schemaId(String name, String nameSpace) {
            this.schemaId = new SchemaId(name, nameSpace);
            return (B)this;
        }

        public NodeKey build() {
            Preconditions.checkNotNull((Object)this.schemaId.name(), (Object)"Schema info is not complete");
            return new NodeKey(this);
        }
    }
}

