/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.base.MoreObjects;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.onosproject.yang.model.AtomicPath;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.LeafIdentifier;
import org.onosproject.yang.model.MultiInstanceLeaf;
import org.onosproject.yang.model.MultiInstanceNode;
import org.onosproject.yang.model.SingleInstanceLeaf;
import org.onosproject.yang.model.SingleInstanceNode;

public final class ModelObjectId {
    private final List<AtomicPath> atomicPaths;

    private ModelObjectId(Builder builder) {
        this.atomicPaths = builder.atomicPathList;
    }

    public List<AtomicPath> atomicPaths() {
        return this.atomicPaths;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(this.atomicPaths);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ModelObjectId that = (ModelObjectId)obj;
        List<AtomicPath> thatList = that.atomicPaths;
        return this.atomicPaths.size() == thatList.size() && this.atomicPaths.containsAll(thatList);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("atomicPaths", this.atomicPaths).toString();
    }

    public static class Builder {
        private final List<AtomicPath> atomicPathList = new LinkedList<AtomicPath>();

        public <T extends InnerModelObject> Builder addChild(Class<T> container) {
            this.atomicPathList.add(new SingleInstanceNode<T>(container));
            return this;
        }

        public <T extends InnerModelObject, K extends KeyInfo<T>> Builder addChild(Class<T> list, K key) {
            this.atomicPathList.add(new MultiInstanceNode<T, K>(list, key));
            return this;
        }

        public <E extends LeafIdentifier> Builder addChild(E leaf) {
            this.atomicPathList.add(new SingleInstanceLeaf<E>(leaf));
            return this;
        }

        public <E extends LeafIdentifier> Builder addChild(E leafList, Object value) {
            this.atomicPathList.add(new MultiInstanceLeaf<E>(leafList, value));
            return this;
        }

        public ModelObjectId build() {
            return new ModelObjectId(this);
        }
    }
}

