/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Objects;
import org.onosproject.yang.model.ModelException;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.model.YangModuleId;

public class DefaultYangModule
implements YangModule {
    private YangModuleId id;
    private Path yangSrc;
    private Path metadata;

    public DefaultYangModule(YangModuleId id, Path yangSrc, Path metadata) {
        Preconditions.checkNotNull((Object)yangSrc);
        Preconditions.checkNotNull((Object)metadata);
        Preconditions.checkNotNull((Object)id);
        this.id = id;
        this.yangSrc = yangSrc;
        this.metadata = metadata;
    }

    @Override
    public YangModuleId getYangModuleId() {
        return this.id;
    }

    @Override
    public InputStream getYangSource() {
        try {
            return new FileInputStream(this.yangSrc.toString());
        }
        catch (FileNotFoundException e) {
            throw new ModelException("Yang source file not found." + this.yangSrc);
        }
    }

    @Override
    public InputStream getMetadata() {
        try {
            return new FileInputStream(this.metadata.toString());
        }
        catch (FileNotFoundException e) {
            throw new ModelException("metadata source file not found." + this.metadata);
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, this.yangSrc, this.metadata);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DefaultYangModule that = (DefaultYangModule)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.yangSrc, that.yangSrc) && Objects.equals(this.metadata, that.metadata);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("moduleId", (Object)this.id).add("yangSource", (Object)this.yangSrc).add("yangMetadata", (Object)this.metadata).toString();
    }
}

