/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import com.google.common.base.MoreObjects;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModule;
import org.onosproject.yang.model.YangModuleId;

public class DefaultYangModel
implements YangModel {
    private final Map<YangModuleId, YangModule> moduleMap;

    private DefaultYangModel(Builder b) {
        this.moduleMap = b.moduleMap;
    }

    @Deprecated
    public DefaultYangModel() {
        this.moduleMap = new LinkedHashMap<YangModuleId, YangModule>();
    }

    @Override
    public Set<YangModule> getYangModules() {
        LinkedHashSet<YangModule> modules = new LinkedHashSet<YangModule>();
        for (Map.Entry<YangModuleId, YangModule> entry : this.moduleMap.entrySet()) {
            modules.add(entry.getValue());
        }
        return modules;
    }

    @Override
    public Set<YangModuleId> getYangModulesId() {
        LinkedHashSet<YangModuleId> ids = new LinkedHashSet<YangModuleId>();
        for (Map.Entry<YangModuleId, YangModule> entry : this.moduleMap.entrySet()) {
            ids.add(entry.getKey());
        }
        return ids;
    }

    @Override
    public YangModule getYangModule(YangModuleId id) {
        return this.moduleMap.get(id);
    }

    @Override
    @Deprecated
    public void addModule(YangModuleId id, YangModule module) {
        this.moduleMap.put(id, module);
    }

    public int hashCode() {
        return Objects.hash(this.moduleMap);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        DefaultYangModel that = (DefaultYangModel)obj;
        if (this.moduleMap.size() == that.moduleMap.size()) {
            for (Map.Entry<YangModuleId, YangModule> entry : this.moduleMap.entrySet()) {
                if (that.moduleMap.containsKey(entry.getKey()) && that.moduleMap.containsValue(entry.getValue())) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("model", this.moduleMap).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements YangModel.Builder {
        private final Map<YangModuleId, YangModule> moduleMap = new LinkedHashMap<YangModuleId, YangModule>();

        @Override
        public Builder addModule(YangModuleId id, YangModule module) {
            this.moduleMap.put(id, module);
            return this;
        }

        @Override
        public YangModel build() {
            return new DefaultYangModel(this);
        }
    }
}

