/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import java.util.LinkedList;
import java.util.List;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;

public class DefaultModelObjectData
implements ModelObjectData {
    private final List<ModelObject> objects;
    private final ModelObjectId identifier;

    protected DefaultModelObjectData(Builder b) {
        this.objects = b.objects;
        this.identifier = b.identifier;
    }

    @Override
    public List<ModelObject> modelObjects() {
        return this.objects;
    }

    @Override
    public ModelObjectId identifier() {
        return this.identifier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements ModelObjectData.Builder {
        private List<ModelObject> objects = new LinkedList<ModelObject>();
        private ModelObjectId identifier;

        @Override
        public Builder addModelObject(ModelObject o) {
            this.objects.add(o);
            return this;
        }

        @Override
        public Builder identifier(ModelObjectId id) {
            this.identifier = id;
            return this;
        }

        @Override
        public ModelObjectData build() {
            return new DefaultModelObjectData(this);
        }
    }
}

