/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.yang.model;

import org.onosproject.yang.model.InnerNode;
import org.onosproject.yang.model.LeafNode;
import org.onosproject.yang.model.NodeKey;

public abstract class DataNode {
    protected Type type;
    protected NodeKey key;

    protected DataNode(Builder builder) {
        this.type = builder.type;
        this.key = builder.key;
    }

    public Type type() {
        return this.type;
    }

    public NodeKey key() {
        return this.key;
    }

    public abstract Builder copyBuilder();

    public static abstract class Builder<B extends Builder<B>> {
        protected Type type;
        protected NodeKey key;
        protected NodeKey.NodeKeyBuilder keyBuilder;
        protected Object appInfo;
        protected InnerNode.Builder parent;

        protected Builder() {
        }

        protected Builder(DataNode node) {
            this.type = node.type;
            this.key = node.key;
        }

        public B key(NodeKey key) {
            this.key = key;
            return (B)this;
        }

        public B parent(InnerNode.Builder node) {
            this.parent = node;
            return (B)this;
        }

        public B parent() {
            return (B)this.parent;
        }

        public B type(Type type) {
            this.type = type;
            return (B)this;
        }

        public abstract InnerNode.Builder createChildBuilder(String var1, String var2);

        public abstract LeafNode.Builder createChildBuilder(String var1, String var2, Object var3);

        public abstract InnerNode.Builder deleteChild(NodeKey var1);

        public abstract InnerNode.Builder getChildBuilder(NodeKey var1);

        public abstract InnerNode.Builder addKeyLeaf(String var1, String var2, Object var3);

        public abstract LeafNode.Builder addLeafListValue(Object var1);

        public abstract DataNode build();

        public InnerNode.Builder exitNode() {
            if (this.parent != null) {
                this.parent.addNode(this.build());
            }
            return this.parent;
        }

        public Object appInfo() {
            return this.appInfo;
        }

        public B appInfo(Object appInfo) {
            this.appInfo = appInfo;
            return (B)this;
        }
    }

    public static enum Type {
        SINGLE_INSTANCE_NODE,
        MULTI_INSTANCE_NODE,
        SINGLE_INSTANCE_LEAF_VALUE_NODE,
        MULTI_INSTANCE_LEAF_VALUE_NODE;

    }
}

