/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.protocol.rest.ctl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.ws.rs.client.WebTarget;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.net.DeviceId;
import org.onosproject.protocol.http.ctl.HttpSBControllerImpl;
import org.onosproject.protocol.rest.RestSBController;
import org.onosproject.protocol.rest.RestSBDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RestSBControllerImpl
extends HttpSBControllerImpl
implements RestSBController {
    private static final Logger log = LoggerFactory.getLogger(RestSBControllerImpl.class);
    private final Map<DeviceId, RestSBDevice> proxiedDeviceMap = new ConcurrentHashMap<DeviceId, RestSBDevice>();

    @Activate
    public void activate() {
        log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.getClientMap().clear();
        this.getDeviceMap().clear();
        log.info("Stopped");
    }

    public void addProxiedDevice(DeviceId deviceId, RestSBDevice proxy) {
        this.proxiedDeviceMap.put(deviceId, proxy);
        log.debug("Added device: {} to proxy {}", (Object)deviceId, (Object)proxy.deviceId());
    }

    public void removeProxiedDevice(DeviceId deviceId) {
        log.debug("Removed device: {} from proxy {}", (Object)deviceId, (Object)this.proxiedDeviceMap.get(deviceId).deviceId());
        this.proxiedDeviceMap.remove(deviceId);
    }

    public Set<DeviceId> getProxiedDevices(DeviceId proxyId) {
        return ImmutableSet.copyOf((Collection)this.proxiedDeviceMap.keySet().stream().filter(v -> this.proxiedDeviceMap.get(v).deviceId().equals((Object)proxyId)).collect(Collectors.toSet()));
    }

    public RestSBDevice getProxySBDevice(DeviceId deviceId) {
        return this.proxiedDeviceMap.get(deviceId);
    }

    protected WebTarget getWebTarget(DeviceId device, String request) {
        DeviceId deviceId = device;
        if (this.proxiedDeviceMap.containsKey(device)) {
            deviceId = this.proxiedDeviceMap.get(device).deviceId();
        }
        return super.getWebTarget(deviceId, request);
    }

    protected String getUrlString(DeviceId id, String request) {
        RestSBDevice device;
        DeviceId deviceId = id;
        if (this.proxiedDeviceMap.containsKey(id)) {
            deviceId = this.proxiedDeviceMap.get(id).deviceId();
        }
        if ((device = (RestSBDevice)super.getDeviceMap().get(deviceId)) != null) {
            if (device.url() != null && !device.url().isEmpty()) {
                return device.protocol() + ":" + "//" + device.ip().toString() + ":" + device.port() + device.url() + request;
            }
            return device.protocol() + ":" + "//" + device.ip().toString() + ":" + device.port() + request;
        }
        return super.getUrlString(deviceId, request);
    }
}

