/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.huawei;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.drivers.huawei.DriverUtil;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.Device;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.Interfaces;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.interfaces.DefaultYangAutoPrefixInterface;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.device.interfaces.YangAutoPrefixInterface;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.DefaultAugmentedIfInterface;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.Ipv4;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv4.Address;
import org.onosproject.yang.gen.v1.ietfip.rev20140616.ietfip.devices.device.interfaces.yangautoprefixinterface.augmentedifinterface.ipv4.address.subnet.PrefixLength;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.DefaultDevice;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.DeviceKeys;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.DefaultL3Vpn;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.DefaultL3Vpncomm;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.DefaultL3VpnInstances;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.DefaultL3VpnInstance;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.L3VpnInstanceKeys;
import org.onosproject.yang.gen.v1.nel3vpncomm.rev20141225.nel3vpncomm.l3vpnifs.DefaultL3VpnIfs;
import org.onosproject.yang.gen.v1.nel3vpncomm.rev20141225.nel3vpncomm.l3vpnifs.L3VpnIfs;
import org.onosproject.yang.gen.v1.nel3vpncomm.rev20141225.nel3vpncomm.l3vpnifs.l3vpnifs.DefaultL3VpnIf;
import org.onosproject.yang.gen.v1.nel3vpncomm.rev20141225.nel3vpncomm.l3vpnifs.l3vpnifs.L3VpnIf;
import org.onosproject.yang.gen.v1.nel3vpncommtype.rev20141225.nel3vpncommtype.Ipv4Address;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;

public final class IntConstructionUtil {
    private static final String ILLEGAL_MASK_LENGTH = "Illegal length of mask is not allowed.";

    private IntConstructionUtil() {
    }

    static ModelObjectData getCreateInt(ModelObjectData modObj) {
        boolean isModIdAvail = true;
        String id = DriverUtil.getIdFromModId(modObj.identifier(), false);
        Object obj = DriverUtil.getObjFromModData(modObj);
        if (id == null) {
            isModIdAvail = false;
            id = IntConstructionUtil.getIdFromRootObj(obj);
            obj = IntConstructionUtil.getObjFromDevObj(obj);
        }
        if (obj == null) {
            throw new IllegalArgumentException("Object from device model cannot be null");
        }
        List intList = ((Interfaces)obj).yangAutoPrefixInterface();
        YangAutoPrefixInterface l3Int = (YangAutoPrefixInterface)intList.get(0);
        org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.interfaces.yangautoprefixinterface.DefaultAugmentedIfInterface ifInt = (org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.interfaces.yangautoprefixinterface.DefaultAugmentedIfInterface)((DefaultYangAutoPrefixInterface)l3Int).augmentation(org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.interfaces.yangautoprefixinterface.DefaultAugmentedIfInterface.class);
        String insName = ifInt.bindNetworkInstanceName();
        L3VpnIfs l3VpnIfs = IntConstructionUtil.getDriverInterfaces(l3Int);
        return IntConstructionUtil.getDriModObj(id, insName, l3VpnIfs, isModIdAvail);
    }

    private static ModelObjectData getDriModObj(String id, String insName, L3VpnIfs l3VpnIfs, boolean isModIdAvail) {
        ModelObjectData data;
        List intList = l3VpnIfs.l3VpnIf();
        Iterator it = intList.iterator();
        L3VpnIf l3VpnIf = (L3VpnIf)it.next();
        ModelObjectId.Builder objId = IntConstructionUtil.getModIdBuilder(id, insName);
        if (isModIdAvail) {
            objId.addChild(DefaultL3VpnIfs.class);
            data = DriverUtil.getData(objId.build(), (InnerModelObject)l3VpnIf);
        } else {
            data = DriverUtil.getData(objId.build(), (InnerModelObject)l3VpnIfs);
        }
        return data;
    }

    private static ModelObjectId.Builder getModIdBuilder(String id, String vpnName) {
        DeviceKeys key = new DeviceKeys();
        key.deviceid(id);
        L3VpnInstanceKeys insKey = new L3VpnInstanceKeys();
        insKey.vrfName(vpnName);
        return ModelObjectId.builder().addChild(DefaultDevices.class).addChild(DefaultDevice.class, (KeyInfo)key).addChild(DefaultL3Vpn.class).addChild(DefaultL3Vpncomm.class).addChild(DefaultL3VpnInstances.class).addChild(DefaultL3VpnInstance.class, (KeyInfo)insKey);
    }

    private static L3VpnIfs getDriverInterfaces(YangAutoPrefixInterface ifs) {
        DefaultL3VpnIfs l3VpnIfs = new DefaultL3VpnIfs();
        DefaultL3VpnIf l3VpnIf = new DefaultL3VpnIf();
        LinkedList<DefaultL3VpnIf> l3VpnIfList = new LinkedList<DefaultL3VpnIf>();
        l3VpnIf.ifName(ifs.name());
        DefaultAugmentedIfInterface ipAug = (DefaultAugmentedIfInterface)((DefaultYangAutoPrefixInterface)ifs).augmentation(DefaultAugmentedIfInterface.class);
        if (ipAug != null && ipAug.ipv4() != null) {
            Ipv4 ipAddress = ipAug.ipv4();
            for (Address add : ipAddress.address()) {
                Ipv4Address v4Add = Ipv4Address.fromString((String)add.ip().ipv4Address().toString());
                Ipv4Address subnet = Ipv4Address.fromString((String)IntConstructionUtil.getSubnet(((PrefixLength)add.subnet()).prefixLength()));
                l3VpnIf.ipv4Addr(v4Add);
                l3VpnIf.subnetMask(subnet);
            }
        }
        l3VpnIfList.add(l3VpnIf);
        l3VpnIfs.l3VpnIf(l3VpnIfList);
        return l3VpnIfs;
    }

    private static String getIdFromRootObj(Object obj) {
        Device dev = IntConstructionUtil.getDevFromRootObj(obj);
        return dev.deviceid();
    }

    private static Device getDevFromRootObj(Object obj) {
        List deviceList = ((org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.DefaultDevices)obj).device();
        Iterator it = deviceList.iterator();
        if (it.hasNext()) {
            return (Device)it.next();
        }
        throw new IllegalArgumentException("Device object from the devices of standard device model cannot be null");
    }

    private static Interfaces getObjFromDevObj(Object obj) {
        Device dev = IntConstructionUtil.getDevFromRootObj(obj);
        return dev.interfaces();
    }

    private static String getSubnet(short mask) {
        InetAddress netAdd;
        int value = -1 << 32 - mask;
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        try {
            netAdd = InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(ILLEGAL_MASK_LENGTH);
        }
        return netAdd.getHostAddress();
    }
}

