/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.huawei;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.onosproject.drivers.huawei.DriverUtil;
import org.onosproject.drivers.huawei.ModelIdLevel;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.devices.device.networkinstances.networkinstance.DefaultAugmentedNiNetworkInstance;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.devices.device.networkinstances.networkinstance.augmentedninetworkinstance.L3Vpn;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.l3vpnvrfparams.ipv4.Unicast;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetset.Rts;
import org.onosproject.yang.gen.v1.ietfbgpl3vpn.rev20160909.ietfbgpl3vpn.routetargetset.rts.RtTypeEnum;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.DefaultDevices;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.Device;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.NetworkInstances;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.networkinstances.DefaultNetworkInstance;
import org.onosproject.yang.gen.v1.ietfnetworkinstance.rev20160623.ietfnetworkinstance.devices.device.networkinstances.NetworkInstance;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.DefaultDevice;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.DeviceKeys;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.DefaultL3Vpn;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.DefaultL3Vpncomm;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.L3Vpncomm;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.DefaultL3VpnInstances;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.L3VpnInstances;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.DefaultL3VpnInstance;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.L3VpnInstance;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.L3VpnInstanceKeys;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.l3vpninstance.DefaultVpnInstAfs;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.l3vpninstance.VpnInstAfs;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.l3vpninstance.vpninstafs.DefaultVpnInstAf;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.l3vpninstance.vpninstafs.vpninstaf.DefaultVpnTargets;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.l3vpninstance.vpninstafs.vpninstaf.VpnTargets;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.l3vpninstance.vpninstafs.vpninstaf.vpntargets.DefaultVpnTarget;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.l3vpn.l3vpncomm.l3vpninstances.l3vpninstance.vpninstafs.vpninstaf.vpntargets.VpnTarget;
import org.onosproject.yang.gen.v1.nel3vpncomm.rev20141225.nel3vpncomm.l3vpnifs.DefaultL3VpnIfs;
import org.onosproject.yang.gen.v1.nel3vpncommtype.rev20141225.nel3vpncommtype.L3VpncommonL3VpnPrefixType;
import org.onosproject.yang.gen.v1.nel3vpncommtype.rev20141225.nel3vpncommtype.L3VpncommonVrfRtType;
import org.onosproject.yang.gen.v1.nel3vpncommtype.rev20141225.nel3vpncommtype.l3vpncommonl3vpnprefixtype.L3VpncommonL3VpnPrefixTypeEnum;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;

public final class InsConstructionUtil {
    private static final String EXP_COMM = "export_extcommunity";
    private static final String IMP_COMM = "import_extcommunity";
    private static final String UNSUPPORTED_RT_TYPE = "The RT type is not supported";

    private InsConstructionUtil() {
    }

    static ModelObjectData getCreateVpnIns(ModelObjectData modObj, boolean isDevAvail) {
        ModelIdLevel modIdLvl = ModelIdLevel.DEVICE;
        String id = DriverUtil.getIdFromModId(modObj.identifier(), true);
        Object obj = DriverUtil.getObjFromModData(modObj);
        if (obj == null) {
            throw new IllegalArgumentException("Object from device model cannot be null");
        }
        if (id == null) {
            id = InsConstructionUtil.getDevIdFromRootObj(obj);
            obj = InsConstructionUtil.getObjFromRootObj(obj);
            modIdLvl = isDevAvail ? ModelIdLevel.DEVICES : ModelIdLevel.ROOT;
        } else if (id.equals("Devices")) {
            modIdLvl = ModelIdLevel.DEVICES;
            id = ((Device)obj).deviceid();
            obj = ((Device)obj).networkInstances();
        }
        org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices devices = InsConstructionUtil.getDriverDevices(id, (NetworkInstances)obj);
        return InsConstructionUtil.getCreateModObjData(modIdLvl, id, devices);
    }

    private static ModelObjectData getCreateModObjData(ModelIdLevel modIdLvl, String devId, org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices devices) {
        List devList = devices.device();
        Iterator it = devList.iterator();
        org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.Device device = (org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.Device)it.next();
        Iterator instIt = device.l3Vpn().l3Vpncomm().l3VpnInstances().l3VpnInstance().iterator();
        L3VpnInstance ins = (L3VpnInstance)instIt.next();
        switch (modIdLvl) {
            case ROOT: {
                return DriverUtil.getData(null, (InnerModelObject)devices);
            }
            case DEVICES: {
                ModelObjectId id = DriverUtil.getModObjIdDriDevices();
                return DriverUtil.getData(id, (InnerModelObject)device);
            }
            case DEVICE: {
                ModelObjectId id = InsConstructionUtil.getModelObjIdForIns(devId).build();
                return DriverUtil.getData(id, (InnerModelObject)ins);
            }
        }
        throw new IllegalArgumentException("The model id level is not supported");
    }

    private static org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices getDriverDevices(String id, NetworkInstances obj) {
        org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices devices = new org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices();
        DefaultDevice device = new DefaultDevice();
        DefaultL3Vpn l3Vpn = new DefaultL3Vpn();
        DefaultL3Vpncomm l3VpnComm = new DefaultL3Vpncomm();
        DefaultL3VpnInstances instances = new DefaultL3VpnInstances();
        DefaultL3VpnInstance ins = new DefaultL3VpnInstance();
        LinkedList<DefaultL3VpnInstance> insList = new LinkedList<DefaultL3VpnInstance>();
        LinkedList<DefaultDevice> devList = new LinkedList<DefaultDevice>();
        InsConstructionUtil.createDriIns(obj, (L3VpnInstance)ins);
        insList.add(ins);
        instances.l3VpnInstance(insList);
        l3VpnComm.l3VpnInstances((L3VpnInstances)instances);
        l3Vpn.l3Vpncomm((L3Vpncomm)l3VpnComm);
        device.deviceid(id);
        device.l3Vpn((org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.devices.device.L3Vpn)l3Vpn);
        devList.add(device);
        devices.device(devList);
        return devices;
    }

    private static void createDriIns(NetworkInstances ins, L3VpnInstance driIns) {
        NetworkInstance networkInstance = (NetworkInstance)ins.networkInstance().iterator().next();
        driIns.vrfName(networkInstance.name());
        DefaultAugmentedNiNetworkInstance augIns = (DefaultAugmentedNiNetworkInstance)((DefaultNetworkInstance)networkInstance).augmentation(DefaultAugmentedNiNetworkInstance.class);
        VpnInstAfs vpnInstAfs = InsConstructionUtil.processL3VpnAf(augIns.l3Vpn());
        driIns.vpnInstAfs(vpnInstAfs);
    }

    private static String getDevIdFromRootObj(Object obj) {
        Device dev = InsConstructionUtil.getDevFromRootObj(obj);
        return dev.deviceid();
    }

    private static Device getDevFromRootObj(Object obj) {
        List deviceList = ((DefaultDevices)obj).device();
        Iterator it = deviceList.iterator();
        if (it.hasNext()) {
            return (Device)it.next();
        }
        throw new IllegalArgumentException("Device object from the devices of standard device model cannot be null");
    }

    private static NetworkInstances getObjFromRootObj(Object obj) {
        Device dev = InsConstructionUtil.getDevFromRootObj(obj);
        return dev.networkInstances();
    }

    private static ModelObjectId.Builder getModelObjIdForIns(String id) {
        ModelObjectId.Builder device = InsConstructionUtil.getModObjIdDriDevice(id);
        return device.addChild(DefaultL3Vpn.class).addChild(DefaultL3Vpncomm.class).addChild(DefaultL3VpnInstances.class);
    }

    private static VpnInstAfs processL3VpnAf(L3Vpn l3Vpn) {
        Unicast ipv4Unicast = l3Vpn.ipv4().unicast();
        DefaultVpnInstAfs vpnInstAfs = new DefaultVpnInstAfs();
        DefaultVpnInstAf vpnInstAf = new DefaultVpnInstAf();
        DefaultVpnTargets vpnTargets = new DefaultVpnTargets();
        LinkedList<DefaultVpnInstAf> afList = new LinkedList<DefaultVpnInstAf>();
        vpnInstAf.vrfRd(l3Vpn.routeDistinguisher().config().rd());
        vpnInstAf.afType(L3VpncommonL3VpnPrefixType.of((L3VpncommonL3VpnPrefixTypeEnum)L3VpncommonL3VpnPrefixTypeEnum.IPV4UNI));
        List rts = ipv4Unicast.routeTargets().config().rts();
        InsConstructionUtil.addVpnTarget((VpnTargets)vpnTargets, rts);
        vpnInstAf.vpnTargets((VpnTargets)vpnTargets);
        afList.add(vpnInstAf);
        vpnInstAfs.vpnInstAf(afList);
        return vpnInstAfs;
    }

    private static void addVpnTarget(VpnTargets vpnTgts, List<Rts> rts) {
        LinkedList<VpnTarget> tgtList = new LinkedList<VpnTarget>();
        for (Rts rt : rts) {
            if (rt == null) continue;
            if (rt.rtType() == RtTypeEnum.BOTH) {
                VpnTarget expTgt = InsConstructionUtil.addRt(rt.rt(), EXP_COMM);
                VpnTarget impTgt = InsConstructionUtil.addRt(rt.rt(), IMP_COMM);
                tgtList.add(expTgt);
                tgtList.add(impTgt);
                continue;
            }
            String rtType = InsConstructionUtil.getRtVal(rt.rtType());
            VpnTarget tgt = InsConstructionUtil.addRt(rt.rt(), rtType);
            tgtList.add(tgt);
        }
        vpnTgts.vpnTarget(tgtList);
    }

    private static String getRtVal(RtTypeEnum type) {
        switch (type) {
            case EXPORT: {
                return EXP_COMM;
            }
            case IMPORT: {
                return IMP_COMM;
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_RT_TYPE);
    }

    private static VpnTarget addRt(String rt, String rtType) {
        DefaultVpnTarget vpnTarget = new DefaultVpnTarget();
        vpnTarget.vrfRtvalue(rt);
        vpnTarget.vrfRttype(L3VpncommonVrfRtType.fromString((String)rtType));
        return vpnTarget;
    }

    static Object getDeleteVpnIns(ModelObjectData modObj) {
        ModelIdLevel modIdLvl = ModelIdLevel.DEVICE;
        String id = DriverUtil.getIdFromModId(modObj.identifier(), true);
        Object obj = DriverUtil.getObjFromModData(modObj);
        if (obj == null) {
            throw new IllegalArgumentException("Object from device model cannot be null");
        }
        if (id == null) {
            modIdLvl = ModelIdLevel.ROOT;
            id = InsConstructionUtil.getDevIdFromRootObj(obj);
            obj = InsConstructionUtil.getObjFromRootObj(obj);
        } else if (id.equals("Devices")) {
            modIdLvl = ModelIdLevel.DEVICES;
            id = ((Device)obj).deviceid();
            obj = ((Device)obj).networkInstances();
        }
        List ins = ((NetworkInstances)obj).networkInstance();
        Iterator it = ins.iterator();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Instance object from the instances of standard device model cannot be null");
        }
        NetworkInstance instance = (NetworkInstance)it.next();
        return InsConstructionUtil.getDelModObjData(modIdLvl, id, instance.name());
    }

    private static ModelObjectData getDelModObjData(ModelIdLevel modIdLvl, String id, String name) {
        switch (modIdLvl) {
            case ROOT: {
                ModelObjectId modId = DriverUtil.getModObjIdDriDevices();
                DefaultDevice device = new DefaultDevice();
                return DriverUtil.getData(modId, (InnerModelObject)device);
            }
            case DEVICES: {
                DefaultL3Vpn l3Vpn = new DefaultL3Vpn();
                ModelObjectId modId = InsConstructionUtil.getModObjIdDriDevice(id).build();
                return DriverUtil.getData(modId, (InnerModelObject)l3Vpn);
            }
            case DEVICE: {
                DefaultL3VpnIfs l3VpnIfs = new DefaultL3VpnIfs();
                ModelObjectId modId = InsConstructionUtil.getModObjIdDriVpn(id, name);
                return DriverUtil.getData(modId, (InnerModelObject)l3VpnIfs);
            }
        }
        throw new IllegalArgumentException("The model id level is not supported");
    }

    private static ModelObjectId getModObjIdDriVpn(String id, String name) {
        ModelObjectId.Builder ins = InsConstructionUtil.getModelObjIdForIns(id);
        L3VpnInstanceKeys key = new L3VpnInstanceKeys();
        key.vrfName(name);
        return ins.addChild(DefaultL3VpnInstance.class, (KeyInfo)key).build();
    }

    private static ModelObjectId.Builder getModObjIdDriDevice(String id) {
        DeviceKeys key = new DeviceKeys();
        key.deviceid(id);
        return ModelObjectId.builder().addChild(org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices.class).addChild(DefaultDevice.class, (KeyInfo)key);
    }
}

