/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.huawei;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.DefaultPortStatistics;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;

public final class HuaweiXmlParser {
    private static final String DATA = "data";
    private static final String IFM = "ifm";
    private static final String IFS = "interfaces";
    private static final String IF = "interface";
    private static final String IF_TYPE = "ifPhyType";
    private static final String IF_STATS = "ifStatistics";
    private static final String IF_STAT = "ifPhyStatus";
    private static final String IF_NUM = "ifNumber";
    private static final String IF_SPEED = "ifOperSpeed";
    private static final String IF_NAME = "ifName";
    private static final String UP = "up";
    private static final String DYN_INFO = "ifDynamicInfo";
    private static final String DELIMITER = "/";
    private static final String SYS = "system";
    private static final String SYS_INFO = "systemInfo";
    private static final String SYS_NAME = "sysName";
    private static final String PDT_VER = "productVer";
    private static final String PLATFORM_VER = "platformVer";
    private static final String SYS_ID = "sysObjectId";
    private static final String P_RCVD = "receivePacket";
    private static final String P_SENT = "sendPacket";
    private static final String B_RCVD = "receiveByte";
    private static final String B_SENT = "sendByte";
    private static final String RX_DROP = "rcvDropPacket";
    private static final String TX_DROP = "sendDropPacket";
    private static final String RX_ERROR = "rcvErrorPacket";
    private static final String TX_ERROR = "sendErrorPacket";
    private static final String DEV_PARSE_ERR = "Unable to parse the received xml reply for system details from the huawei device";
    private static final String INT_PARSE_ERR = "Unable to parse the received xml reply for interface details from the huawei device";
    private static final String P_NAME_INVALID = "Invalid port name.";
    private static final List INTERFACES = Arrays.asList("MEth", "Ethernet", "POS", "GigabitEthernet");
    private List<PortDescription> ports = new ArrayList<PortDescription>();
    private String xml;
    private int portInc;
    private String[] info = new String[4];

    public HuaweiXmlParser(String xml) {
        this.xml = xml;
    }

    String[] getInfo() {
        return this.info;
    }

    List<PortDescription> getPorts() {
        return this.ports;
    }

    void parseSysInfo() {
        Document doc;
        try {
            doc = DocumentHelper.parseText((String)this.xml);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException(DEV_PARSE_ERR);
        }
        Element root = doc.getRootElement();
        Element parent = root.element(DATA).element(SYS).element(SYS_INFO);
        this.info[0] = parent.element(SYS_NAME).getText();
        this.info[1] = parent.element(PDT_VER).getText();
        this.info[2] = parent.element(PLATFORM_VER).getText();
        this.info[3] = parent.element(SYS_ID).getText();
    }

    void parseInterfaces() {
        Iterator itr = this.getInterfaceIterator();
        while (itr.hasNext()) {
            Element ifElement = (Element)itr.next();
            this.addPorts(ifElement);
        }
    }

    private Iterator getInterfaceIterator() {
        Document doc;
        try {
            doc = DocumentHelper.parseText((String)this.xml);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException(INT_PARSE_ERR);
        }
        Element root = doc.getRootElement();
        Element parent = root.element(DATA).element(IFM).element(IFS);
        return parent.elementIterator(IF);
    }

    private void addPorts(Element ifElement) {
        String ifType = ifElement.element(IF_TYPE).getText();
        if (INTERFACES.contains(ifType)) {
            Element info = ifElement.element(DYN_INFO);
            String status = info.element(IF_STAT).getText();
            String port = this.getPortNum(ifElement.element(IF_NUM).getText());
            String speed = info.element(IF_SPEED).getText();
            String ifName = ifElement.element(IF_NAME).getText();
            boolean isEnabled = false;
            if (status.equals(UP)) {
                isEnabled = true;
            }
            Long portSpeed = 0L;
            if (!speed.isEmpty()) {
                portSpeed = Long.valueOf(speed);
            }
            DefaultAnnotations annotations = DefaultAnnotations.builder().set("portName", ifName).build();
            this.ports.add((PortDescription)new DefaultPortDescription(PortNumber.portNumber((String)port), isEnabled, Port.Type.COPPER, portSpeed.longValue(), new SparseAnnotations[]{annotations}));
        }
    }

    private String getPortNum(String portName) {
        String port;
        if (!portName.contains(DELIMITER)) {
            ++this.portInc;
            port = String.valueOf(this.portInc) + portName;
        } else if (portName.indexOf(DELIMITER) > 0) {
            try {
                port = portName.substring(portName.lastIndexOf(DELIMITER) + 1);
                ++this.portInc;
                port = String.valueOf(this.portInc) + port;
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new IllegalArgumentException(P_NAME_INVALID);
            }
        } else {
            throw new IllegalArgumentException(P_NAME_INVALID);
        }
        return port;
    }

    Collection<PortStatistics> parsePortsStatistics(DeviceId deviceId) {
        ArrayList pss = Lists.newArrayList();
        Iterator itr = this.getInterfaceIterator();
        while (itr.hasNext()) {
            Element ifElement = (Element)itr.next();
            pss.add(this.getPortStatistics(ifElement, deviceId));
        }
        return pss;
    }

    private PortStatistics getPortStatistics(Element ifElement, DeviceId id) {
        String ifType = ifElement.element(IF_TYPE).getText();
        DefaultPortStatistics.Builder builder = DefaultPortStatistics.builder();
        if (INTERFACES.contains(ifType)) {
            int port = Integer.parseInt(this.getPortNum(ifElement.element(IF_NUM).getText()));
            Element statInfo = ifElement.element(IF_STATS);
            long packetReceived = Long.parseLong(statInfo.element(P_RCVD).getText());
            long packetSent = Long.parseLong(statInfo.element(P_SENT).getText());
            long bytesReceived = Long.parseLong(statInfo.element(B_RCVD).getText());
            long bytesSent = Long.parseLong(statInfo.element(B_SENT).getText());
            long packetsRxDropped = Long.parseLong(statInfo.element(RX_DROP).getText());
            long packetsTxDropped = Long.parseLong(statInfo.element(TX_DROP).getText());
            long packetsRxErrors = Long.parseLong(statInfo.element(RX_ERROR).getText());
            long packetsTxErrors = Long.parseLong(statInfo.element(TX_ERROR).getText());
            return builder.setDeviceId(id).setPort(port).setPacketsReceived(packetReceived).setPacketsSent(packetSent).setBytesReceived(bytesReceived).setBytesSent(bytesSent).setPacketsRxDropped(packetsRxDropped).setPacketsRxErrors(packetsRxErrors).setPacketsTxDropped(packetsTxDropped).setPacketsTxErrors(packetsTxErrors).build();
        }
        return builder.build();
    }
}

