/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.huawei;

import java.util.Iterator;
import org.onlab.osgi.ServiceNotFoundException;
import org.onosproject.config.DynamicConfigService;
import org.onosproject.config.FailedException;
import org.onosproject.drivers.huawei.BgpConstructionUtil;
import org.onosproject.drivers.huawei.InsConstructionUtil;
import org.onosproject.drivers.huawei.IntConstructionUtil;
import org.onosproject.l3vpn.netl3vpn.BgpDriverInfo;
import org.onosproject.l3vpn.netl3vpn.BgpInfo;
import org.onosproject.net.behaviour.L3VpnConfig;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.NeBgpcomm;
import org.onosproject.yang.gen.v1.nebgpcommtype.rev20141225.NeBgpcommType;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.NeL3VpnApi;
import org.onosproject.yang.gen.v1.nel3vpncomm.rev20141225.NeL3Vpncomm;
import org.onosproject.yang.gen.v1.nel3vpncommtype.rev20141225.NeL3VpncommType;
import org.onosproject.yang.model.DataNode;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ResourceId;
import org.onosproject.yang.model.YangModel;
import org.onosproject.yang.model.YangModuleId;
import org.onosproject.yang.runtime.AppModuleInfo;
import org.onosproject.yang.runtime.DefaultAppModuleInfo;
import org.onosproject.yang.runtime.DefaultModelRegistrationParam;
import org.onosproject.yang.runtime.ModelRegistrationParam;
import org.onosproject.yang.runtime.YangModelRegistry;
import org.onosproject.yang.runtime.helperutils.YangApacheUtils;

public class HuaweiL3VpnConfig
extends AbstractHandlerBehaviour
implements L3VpnConfig {
    protected YangModelRegistry modelRegistry;
    protected DynamicConfigService configService;

    private void init() {
        try {
            this.modelRegistry = (YangModelRegistry)this.handler().get(YangModelRegistry.class);
            this.configService = (DynamicConfigService)this.handler().get(DynamicConfigService.class);
            this.registerModel();
        }
        catch (ServiceNotFoundException e) {
            throw new ServiceNotFoundException("Service required for huawei driver is not found.");
        }
    }

    private void registerModel() {
        YangModel model = YangApacheUtils.getYangModel(NeBgpcomm.class);
        Iterator it = model.getYangModulesId().iterator();
        ModelRegistrationParam.Builder b = DefaultModelRegistrationParam.builder().setYangModel(model);
        while (it.hasNext()) {
            YangModuleId id = (YangModuleId)it.next();
            switch (id.moduleName()) {
                case "ne-bgpcomm": {
                    b.addAppModuleInfo(id, (AppModuleInfo)new DefaultAppModuleInfo(NeBgpcomm.class, null));
                    break;
                }
                case "ne-bgpcomm-type": {
                    b.addAppModuleInfo(id, (AppModuleInfo)new DefaultAppModuleInfo(NeBgpcommType.class, null));
                    break;
                }
                case "ne-l3vpn-api": {
                    b.addAppModuleInfo(id, (AppModuleInfo)new DefaultAppModuleInfo(NeL3VpnApi.class, null));
                    break;
                }
                case "ne-l3vpncomm": {
                    b.addAppModuleInfo(id, (AppModuleInfo)new DefaultAppModuleInfo(NeL3Vpncomm.class, null));
                    break;
                }
                case "ne-l3vpncomm-type": {
                    b.addAppModuleInfo(id, (AppModuleInfo)new DefaultAppModuleInfo(NeL3VpncommType.class, null));
                    break;
                }
            }
        }
        ModelRegistrationParam regParam = b.build();
        this.modelRegistry.registerModel(regParam);
    }

    public Object createInstance(Object objectData) {
        if (this.modelRegistry == null) {
            this.init();
        }
        return InsConstructionUtil.getCreateVpnIns((ModelObjectData)objectData, this.isDevicesPresent());
    }

    public Object bindInterface(Object objectData) {
        return IntConstructionUtil.getCreateInt((ModelObjectData)objectData);
    }

    public Object createBgpInfo(Object bgpInfo, Object bgpConfig) {
        return BgpConstructionUtil.getCreateBgp((BgpInfo)bgpInfo, (BgpDriverInfo)bgpConfig);
    }

    public Object deleteInstance(Object objectData) {
        return InsConstructionUtil.getDeleteVpnIns((ModelObjectData)objectData);
    }

    public Object unbindInterface(Object objectData) {
        return null;
    }

    public Object deleteBgpInfo(Object bgpInfo, Object bgpConfig) {
        return BgpConstructionUtil.getDeleteBgp((BgpInfo)bgpInfo, (BgpDriverInfo)bgpConfig);
    }

    private boolean isDevicesPresent() {
        ResourceId resId = ResourceId.builder().addBranchPointSchema("/", null).addBranchPointSchema("devices", "ne-l3vpn-api").build();
        try {
            DataNode node = this.configService.readNode(resId, null);
            if (node != null) {
                return true;
            }
        }
        catch (FailedException e) {
            return false;
        }
        return false;
    }
}

