/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.huawei;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.onosproject.drivers.huawei.HuaweiXmlParser;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultDeviceDescription;
import org.onosproject.net.device.DeviceDescription;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.device.PortDescription;
import org.onosproject.net.device.PortStatistics;
import org.onosproject.net.device.PortStatisticsDiscovery;
import org.onosproject.net.driver.AbstractHandlerBehaviour;
import org.onosproject.netconf.NetconfController;
import org.onosproject.netconf.NetconfDevice;
import org.onosproject.netconf.NetconfException;
import org.onosproject.netconf.NetconfSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiDeviceDescription
extends AbstractHandlerBehaviour
implements PortStatisticsDiscovery {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public DeviceDescription discoverDeviceDetails() {
        String sysInfo;
        NetconfSession session = this.getNetconfSession();
        try {
            sysInfo = session.get(this.getVersionReq());
        }
        catch (IOException e) {
            throw new IllegalArgumentException((Throwable)new NetconfException("Failed to retrieve device info."));
        }
        String[] details = this.parseSysInfoXml(sysInfo);
        DeviceService devSvc = (DeviceService)Preconditions.checkNotNull((Object)this.handler().get(DeviceService.class));
        DeviceId devId = this.handler().data().deviceId();
        Device dev = devSvc.getDevice(devId);
        return new DefaultDeviceDescription(dev.id().uri(), Device.Type.ROUTER, details[0], details[1], details[2], details[3], dev.chassisId(), new SparseAnnotations[0]);
    }

    public List<PortDescription> discoverPortDetails() {
        return ImmutableList.copyOf(this.parseInterfaceXml(this.getInterfaces()));
    }

    private NetconfSession getNetconfSession() {
        NetconfController controller = (NetconfController)Preconditions.checkNotNull((Object)this.handler().get(NetconfController.class));
        return ((NetconfDevice)controller.getDevicesMap().get(this.handler().data().deviceId())).getSession();
    }

    private String getVersionReq() {
        StringBuilder rpc = new StringBuilder("<rpc message-id=\"101\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        rpc.append("<get>");
        rpc.append("<filter type=\"subtree\">");
        rpc.append("<system xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"/>");
        rpc.append("</filter>");
        rpc.append("</get>");
        rpc.append("</rpc>");
        return rpc.toString();
    }

    private String[] parseSysInfoXml(String sysInfo) {
        HuaweiXmlParser parser = new HuaweiXmlParser(sysInfo);
        parser.parseSysInfo();
        return parser.getInfo();
    }

    private String getInterfacesReq() {
        StringBuilder rpc = new StringBuilder("<rpc message-id=\"101\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">");
        rpc.append("<get>");
        rpc.append("<filter type=\"subtree\">");
        rpc.append("<ifm xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\">");
        rpc.append("<interfaces><interface><ifPhyType>Ethernet</ifPhyType><ifName></ifName><ifNumber></ifNumber><ifDynamicInfo></ifDynamicInfo><ifStatistics></ifStatistics></interface></interfaces>");
        rpc.append("</ifm>");
        rpc.append("</filter>");
        rpc.append("</get>");
        rpc.append("</rpc>");
        return rpc.toString();
    }

    private List<PortDescription> parseInterfaceXml(String interfaces) {
        HuaweiXmlParser parser = new HuaweiXmlParser(interfaces);
        parser.parseInterfaces();
        return parser.getPorts();
    }

    public Collection<PortStatistics> discoverPortStatistics() {
        String interfaces = this.getInterfaces();
        if (StringUtils.isNotBlank((String)interfaces)) {
            Collection<PortStatistics> portStats = this.getPortStatistics(interfaces);
            return ImmutableList.copyOf(portStats);
        }
        return null;
    }

    private String getInterfaces() {
        NetconfSession session = this.getNetconfSession();
        String interfaces = null;
        try {
            interfaces = session.get(this.getInterfacesReq());
        }
        catch (IOException e) {
            this.log.info("Failed to retrive interface {} ", (Object)e.getMessage());
        }
        return interfaces;
    }

    private Collection<PortStatistics> getPortStatistics(String ifs) {
        HuaweiXmlParser parser = new HuaweiXmlParser(ifs);
        return parser.parsePortsStatistics(this.handler().data().deviceId());
    }
}

