/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.huawei;

import java.util.Iterator;
import java.util.List;
import org.onosproject.drivers.huawei.L3VpnUtil;
import org.onosproject.yang.gen.v1.ietfinterfaces.rev20140508.ietfinterfaces.devices.DeviceKeys;
import org.onosproject.yang.gen.v1.nel3vpnapi.rev20141225.nel3vpnapi.DefaultDevices;
import org.onosproject.yang.model.AtomicPath;
import org.onosproject.yang.model.DefaultModelObjectData;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.ModelObject;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;
import org.onosproject.yang.model.MultiInstanceNode;

public final class DriverUtil {
    static final String CONS_DEVICES = "Devices";
    static final String SERVICE_NOT_FOUND = "Service required for huawei driver is not found.";
    static final String OBJECT_NULL = "Object from device model cannot be null";
    static final String DEVICE_NULL = "Device object from the devices of standard device model cannot be null";
    static final String INS_NULL = "Instance object from the instances of standard device model cannot be null";
    static final String UNSUPPORTED_MODEL_LVL = "The model id level is not supported";
    static final String DEV_INFO_FAILURE = "Failed to retrieve device info.";
    static final String INT_INFO_FAILURE = "Failed to retrieve Interfaces";
    static final String RPC_MSG = "<rpc message-id=\"101\" xmlns=\"urn:ietf:params:xml:ns:netconf:base:1.0\">";
    static final String RPC_GET = "<get>";
    static final String RPC_FILTER = "<filter type=\"subtree\">";
    static final String RPC_SYS = "<system xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\"/>";
    static final String RPC_IFM = "<ifm xmlns=\"http://www.huawei.com/netconf/vrp\" format-version=\"1.0\" content-version=\"1.0\">";
    static final String RPC_IFS = "<interfaces><interface><ifPhyType>Ethernet</ifPhyType><ifName></ifName><ifNumber></ifNumber><ifDynamicInfo></ifDynamicInfo><ifStatistics></ifStatistics></interface></interfaces>";
    static final String RPC_CLOSE_IFM = "</ifm>";
    static final String RPC_CLOSE_FILTER = "</filter>";
    static final String RPC_CLOSE = "</rpc>";
    static final String RPC_CLOSE_GET = "</get>";
    static final String SLASH = "/";
    static final String DEVICES = "devices";
    static final String NAMESPACE = "ne-l3vpn-api";
    private static final String MODEL_OBJ_ID_LIMIT = "The model object id must not have more than two objects.";

    private DriverUtil() {
    }

    static String getIdFromModId(ModelObjectId id, boolean isIns) {
        if (id == null) {
            return null;
        }
        List paths = id.atomicPaths();
        int size = paths.size();
        switch (size) {
            case 1: {
                return CONS_DEVICES;
            }
            case 2: {
                return DriverUtil.getDevId(paths, isIns);
            }
        }
        throw new IllegalArgumentException(MODEL_OBJ_ID_LIMIT);
    }

    private static String getDevId(List<AtomicPath> paths, boolean isIns) {
        MultiInstanceNode info = (MultiInstanceNode)paths.get(1);
        KeyInfo key = info.key();
        if (!isIns) {
            return ((DeviceKeys)key).deviceid();
        }
        return L3VpnUtil.getDevIdFromIns(key);
    }

    static Object getObjFromModData(ModelObjectData modData) {
        List obj = modData.modelObjects();
        Iterator it = obj.iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    static ModelObjectId getModObjIdDriDevices() {
        return ModelObjectId.builder().addChild(DefaultDevices.class).build();
    }

    static ModelObjectData getData(ModelObjectId id, InnerModelObject obj) {
        return DefaultModelObjectData.builder().addModelObject((ModelObject)obj).identifier(id).build();
    }
}

