/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.drivers.huawei;

import java.util.LinkedList;
import java.util.Map;
import org.onosproject.drivers.huawei.DriverUtil;
import org.onosproject.l3vpn.netl3vpn.BgpDriverInfo;
import org.onosproject.l3vpn.netl3vpn.BgpInfo;
import org.onosproject.l3vpn.netl3vpn.BgpModelIdLevel;
import org.onosproject.l3vpn.netl3vpn.ProtocolInfo;
import org.onosproject.l3vpn.netl3vpn.RouteProtocol;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.DefaultDevices;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.DefaultDevice;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.Device;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.DeviceKeys;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.Bgp;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.DefaultBgp;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.Bgpcomm;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.DefaultBgpcomm;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.BgpVrfs;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.DefaultBgpVrfs;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.BgpVrf;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.BgpVrfKeys;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.DefaultBgpVrf;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.BgpVrfAfs;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.DefaultBgpVrfAfs;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.BgpVrfAf;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.BgpVrfAfKeys;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.DefaultBgpVrfAf;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.bgpvrfaf.DefaultImportRoutes;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.bgpvrfaf.ImportRoutes;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.bgpvrfaf.importroutes.DefaultImportRoute;
import org.onosproject.yang.gen.v1.nebgpcomm.rev20141225.nebgpcomm.devices.device.bgp.bgpcomm.bgpvrfs.bgpvrf.bgpvrfafs.bgpvrfaf.importroutes.ImportRoute;
import org.onosproject.yang.gen.v1.nebgpcommtype.rev20141225.nebgpcommtype.BgpcommImRouteProtocol;
import org.onosproject.yang.gen.v1.nebgpcommtype.rev20141225.nebgpcommtype.BgpcommPrefixType;
import org.onosproject.yang.gen.v1.nebgpcommtype.rev20141225.nebgpcommtype.bgpcommimrouteprotocol.BgpcommImRouteProtocolEnum;
import org.onosproject.yang.gen.v1.nebgpcommtype.rev20141225.nebgpcommtype.bgpcommprefixtype.BgpcommPrefixTypeEnum;
import org.onosproject.yang.model.InnerModelObject;
import org.onosproject.yang.model.KeyInfo;
import org.onosproject.yang.model.ModelObjectData;
import org.onosproject.yang.model.ModelObjectId;

public final class BgpConstructionUtil {
    private static final String UNSUPPORTED_PRO_TYPE = "Unsupported route protocol type is found.";

    private BgpConstructionUtil() {
    }

    static ModelObjectData getCreateBgp(BgpInfo bgpInfo, BgpDriverInfo config) {
        String devId = config.devId();
        BgpModelIdLevel modIdLevel = config.modIdLevel();
        DefaultBgp bgp = new DefaultBgp();
        DefaultBgpcomm bgpBuilder = new DefaultBgpcomm();
        DefaultBgpVrfs bgpVrfs = new DefaultBgpVrfs();
        DefaultBgpVrf bgpVrf = new DefaultBgpVrf();
        DefaultBgpVrfAfs bgpVrfAfs = new DefaultBgpVrfAfs();
        LinkedList<DefaultBgpVrf> bgpVrfList = new LinkedList<DefaultBgpVrf>();
        bgpVrf.vrfName(bgpInfo.vpnName());
        Map proMap = bgpInfo.protocolInfo();
        ImportRoute route = BgpConstructionUtil.addRouteProtocol(proMap, (BgpVrfAfs)bgpVrfAfs);
        bgpVrf.bgpVrfAfs((BgpVrfAfs)bgpVrfAfs);
        bgpVrfList.add(bgpVrf);
        bgpVrfs.bgpVrf(bgpVrfList);
        bgpBuilder.bgpVrfs((BgpVrfs)bgpVrfs);
        bgp.bgpcomm((Bgpcomm)bgpBuilder);
        return BgpConstructionUtil.getModObjData(modIdLevel, (Bgp)bgp, devId, (BgpVrf)bgpVrf, route);
    }

    private static ImportRoute addRouteProtocol(Map<RouteProtocol, ProtocolInfo> proMap, BgpVrfAfs bgpVrfAfs) {
        DefaultBgpVrfAf ipv4 = new DefaultBgpVrfAf();
        DefaultImportRoutes ipv4Routes = new DefaultImportRoutes();
        ipv4.afType(BgpcommPrefixType.of((BgpcommPrefixTypeEnum)BgpcommPrefixTypeEnum.IPV4UNI));
        ImportRoute route = null;
        DefaultBgpVrfAf ipv6 = new DefaultBgpVrfAf();
        DefaultImportRoutes ipv6Routes = new DefaultImportRoutes();
        ipv6.afType(BgpcommPrefixType.of((BgpcommPrefixTypeEnum)BgpcommPrefixTypeEnum.IPV6UNI));
        for (Map.Entry<RouteProtocol, ProtocolInfo> info : proMap.entrySet()) {
            RouteProtocol protocol = info.getKey();
            ProtocolInfo proInfo = info.getValue();
            if (proInfo.isIpv4Af()) {
                route = BgpConstructionUtil.addImportRoute((ImportRoutes)ipv4Routes, proInfo, protocol);
            }
            if (!proInfo.isIpv6Af()) continue;
            BgpConstructionUtil.addImportRoute((ImportRoutes)ipv6Routes, proInfo, protocol);
        }
        if (ipv4Routes.importRoute() != null && !ipv4Routes.importRoute().isEmpty()) {
            BgpConstructionUtil.addToBgpVrf((ImportRoutes)ipv4Routes, (BgpVrfAf)ipv4, bgpVrfAfs);
        }
        if (ipv6Routes.importRoute() != null && !ipv6Routes.importRoute().isEmpty()) {
            BgpConstructionUtil.addToBgpVrf((ImportRoutes)ipv6Routes, (BgpVrfAf)ipv6, bgpVrfAfs);
        }
        return route;
    }

    private static void addToBgpVrf(ImportRoutes routes, BgpVrfAf vrfAf, BgpVrfAfs bgpVrfAfs) {
        LinkedList<BgpVrfAf> ipList = new LinkedList<BgpVrfAf>();
        vrfAf.importRoutes(routes);
        ipList.add(vrfAf);
        bgpVrfAfs.bgpVrfAf(ipList);
    }

    private static ImportRoute addImportRoute(ImportRoutes routes, ProtocolInfo proInfo, RouteProtocol protocol) {
        LinkedList<ImportRoute> routeList = new LinkedList<ImportRoute>();
        ImportRoute route = BgpConstructionUtil.buildAfBgp(proInfo, protocol);
        routeList.add(route);
        routes.importRoute(routeList);
        return route;
    }

    private static ImportRoute buildAfBgp(ProtocolInfo proInfo, RouteProtocol protocol) {
        BgpcommImRouteProtocolEnum rpEnum = BgpConstructionUtil.getProtocolType(protocol);
        DefaultImportRoute impRoute = new DefaultImportRoute();
        impRoute.importProcessId(proInfo.processId());
        impRoute.importProtocol(BgpcommImRouteProtocol.of((BgpcommImRouteProtocolEnum)rpEnum));
        return impRoute;
    }

    private static BgpcommImRouteProtocolEnum getProtocolType(RouteProtocol protocol) {
        switch (protocol) {
            case DIRECT: {
                return BgpcommImRouteProtocolEnum.DIRECT;
            }
            case OSPF: {
                return BgpcommImRouteProtocolEnum.OSPF;
            }
            case RIP: {
                return BgpcommImRouteProtocolEnum.RIP;
            }
            case RIP_NG: {
                return BgpcommImRouteProtocolEnum.RIPNG;
            }
            case STATIC: {
                return BgpcommImRouteProtocolEnum.STATIC;
            }
        }
        throw new IllegalArgumentException(UNSUPPORTED_PRO_TYPE);
    }

    public static ModelObjectData getModObjData(BgpModelIdLevel modIdLevel, Bgp bgp, String devId, BgpVrf bgpVrf, ImportRoute route) {
        switch (modIdLevel) {
            case VPN: {
                return BgpConstructionUtil.getRouteProModObj(bgpVrf.vrfName(), route, devId);
            }
            case ROOT: {
                return BgpConstructionUtil.getRootModObj(bgp, devId);
            }
            case DEVICES: {
                return BgpConstructionUtil.getDevicesModObj(bgp, devId);
            }
            case DEVICE: {
                return BgpConstructionUtil.getDevModObj(bgpVrf, devId);
            }
        }
        throw new IllegalArgumentException("The model id level is not supported");
    }

    private static ModelObjectData getRouteProModObj(String vpnName, ImportRoute route, String devId) {
        DeviceKeys key = new DeviceKeys();
        key.deviceid(devId);
        BgpVrfKeys vpnKey = new BgpVrfKeys();
        vpnKey.vrfName(vpnName);
        BgpVrfAfKeys afKey = new BgpVrfAfKeys();
        afKey.afType(BgpcommPrefixType.of((BgpcommPrefixTypeEnum)BgpcommPrefixTypeEnum.IPV4UNI));
        ModelObjectId id = ModelObjectId.builder().addChild(DefaultDevices.class).addChild(DefaultDevice.class, (KeyInfo)key).addChild(DefaultBgp.class).addChild(DefaultBgpcomm.class).addChild(DefaultBgpVrfs.class).addChild(DefaultBgpVrf.class, (KeyInfo)vpnKey).addChild(DefaultBgpVrfAfs.class).addChild(DefaultBgpVrfAf.class, (KeyInfo)afKey).addChild(DefaultImportRoutes.class).build();
        return DriverUtil.getData(id, (InnerModelObject)route);
    }

    private static ModelObjectData getDevModObj(BgpVrf bgpVrf, String devId) {
        DeviceKeys key = new DeviceKeys();
        key.deviceid(devId);
        ModelObjectId id = ModelObjectId.builder().addChild(DefaultDevices.class).addChild(DefaultDevice.class, (KeyInfo)key).addChild(DefaultBgp.class).addChild(DefaultBgpcomm.class).addChild(DefaultBgpVrfs.class).build();
        return DriverUtil.getData(id, (InnerModelObject)bgpVrf);
    }

    private static ModelObjectData getDevicesModObj(Bgp bgp, String devId) {
        ModelObjectId modelId = ModelObjectId.builder().addChild(DefaultDevices.class).build();
        Device device = BgpConstructionUtil.getDevInfo(bgp, devId);
        return DriverUtil.getData(modelId, (InnerModelObject)device);
    }

    private static ModelObjectData getRootModObj(Bgp bgp, String devId) {
        DefaultDevices devices = new DefaultDevices();
        LinkedList<Device> devList = new LinkedList<Device>();
        Device device = BgpConstructionUtil.getDevInfo(bgp, devId);
        devList.add(device);
        devices.device(devList);
        return DriverUtil.getData(null, (InnerModelObject)devices);
    }

    private static Device getDevInfo(Bgp bgp, String devId) {
        DefaultDevice device = new DefaultDevice();
        device.deviceid(devId);
        device.bgp(bgp);
        return device;
    }

    static ModelObjectData getDeleteBgp(BgpInfo bgpInfo, BgpDriverInfo bgpConfig) {
        BgpModelIdLevel modIdLvl = bgpConfig.modIdLevel();
        switch (modIdLvl) {
            case ROOT: {
                return BgpConstructionUtil.getDelRootModObj();
            }
            case DEVICES: {
                return BgpConstructionUtil.getDelDevicesModObj(bgpConfig.devId());
            }
            case DEVICE: {
                return BgpConstructionUtil.getDelDeviceModObj(bgpConfig.devId(), bgpInfo.vpnName());
            }
        }
        throw new IllegalArgumentException("The model id level is not supported");
    }

    private static ModelObjectData getDelDeviceModObj(String devId, String vpnName) {
        DeviceKeys devKeys = new DeviceKeys();
        devKeys.deviceid(devId);
        BgpVrfKeys vpnKey = new BgpVrfKeys();
        vpnKey.vrfName(vpnName);
        ModelObjectId modelId = ModelObjectId.builder().addChild(DefaultDevices.class).addChild(DefaultDevice.class, (KeyInfo)devKeys).addChild(DefaultBgp.class).addChild(DefaultBgpcomm.class).addChild(DefaultBgpVrfs.class).addChild(DefaultBgpVrf.class, (KeyInfo)vpnKey).build();
        DefaultBgpVrfAfs afs = new DefaultBgpVrfAfs();
        return DriverUtil.getData(modelId, (InnerModelObject)afs);
    }

    private static ModelObjectData getDelRootModObj() {
        DefaultDevice device = new DefaultDevice();
        ModelObjectId modelId = ModelObjectId.builder().addChild(DefaultDevices.class).build();
        return DriverUtil.getData(modelId, (InnerModelObject)device);
    }

    private static ModelObjectData getDelDevicesModObj(String id) {
        DeviceKeys devKeys = new DeviceKeys();
        devKeys.deviceid(id);
        ModelObjectId modelId = ModelObjectId.builder().addChild(DefaultDevices.class).addChild(DefaultDevice.class, (KeyInfo)devKeys).build();
        DefaultBgp bgp = new DefaultBgp();
        return DriverUtil.getData(modelId, (InnerModelObject)bgp);
    }
}

