/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pcestore;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.intent.Constraint;
import org.onosproject.pce.pceservice.ExplicitPathInfo;
import org.onosproject.pce.pceservice.LspType;

public final class PcePathInfo {
    private DeviceId src;
    private DeviceId dst;
    private String name;
    private List<Constraint> constraints;
    private LspType lspType;
    private List<ExplicitPathInfo> explicitPathInfo;
    private boolean loadBalancing;

    public PcePathInfo(DeviceId src, DeviceId dst, String name, List<Constraint> constraints, LspType lspType, List<ExplicitPathInfo> explicitPathInfo, boolean loadBalancing) {
        this.src = src;
        this.dst = dst;
        this.name = name;
        this.constraints = constraints;
        this.lspType = lspType;
        this.explicitPathInfo = explicitPathInfo;
        this.loadBalancing = loadBalancing;
    }

    public PcePathInfo() {
        this.src = null;
        this.dst = null;
        this.name = null;
        this.constraints = null;
        this.lspType = null;
        this.explicitPathInfo = null;
        this.loadBalancing = false;
    }

    public DeviceId src() {
        return this.src;
    }

    public void src(DeviceId id) {
        this.src = id;
    }

    public DeviceId dst() {
        return this.dst;
    }

    public void dst(DeviceId id) {
        this.dst = id;
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public List<Constraint> constraints() {
        return this.constraints;
    }

    public void constraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public LspType lspType() {
        return this.lspType;
    }

    public void lspType(LspType lspType) {
        this.lspType = lspType;
    }

    public List<ExplicitPathInfo> explicitPathInfo() {
        return this.explicitPathInfo;
    }

    public void explicitPathInfo(List<ExplicitPathInfo> explicitPathInfo) {
        this.explicitPathInfo = explicitPathInfo;
    }

    public boolean isLoadBalancing() {
        return this.loadBalancing;
    }

    public void loadBalancing(boolean loadBalancing) {
        this.loadBalancing = loadBalancing;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.src, this.dst, this.name, this.constraints, this.lspType, this.explicitPathInfo, this.loadBalancing});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PcePathInfo) {
            PcePathInfo other = (PcePathInfo)obj;
            return Objects.equals(this.src, other.src) && Objects.equals(this.dst, other.dst) && Objects.equals(this.name, other.name) && Objects.equals(this.constraints, other.constraints) && Objects.equals((Object)this.lspType, (Object)other.lspType) && Objects.equals(this.explicitPathInfo, other.explicitPathInfo) && Objects.equals(this.loadBalancing, other.loadBalancing);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("Source", (Object)this.src).add("Destination", (Object)this.dst).add("Name", (Object)this.name).add("Constraints", this.constraints).add("explicitPathInfo", this.explicitPathInfo).add("LspType", (Object)this.lspType).add("loadBalancing", this.loadBalancing).toString();
    }
}

