/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pcestore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.pce.pceservice.ExplicitPathInfo;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.constraint.CapabilityConstraint;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pceservice.constraint.PceBandwidthConstraint;
import org.onosproject.pce.pceservice.constraint.SharedBandwidthConstraint;
import org.onosproject.pce.pcestore.PcePathInfo;
import org.onosproject.pce.pcestore.api.PceStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedPceStore
implements PceStore {
    private static final String PATH_INFO_NULL = "Path Info cannot be null";
    private static final String PCECC_TUNNEL_INFO_NULL = "PCECC Tunnel Info cannot be null";
    private static final String TUNNEL_ID_NULL = "Tunnel Id cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<String, List<TunnelId>> tunnelNameDisjoinTunnelIdInfo;
    private DistributedSet<PcePathInfo> failedPathSet;
    private ConsistentMap<String, List<ExplicitPathInfo>> tunnelNameExplicitPathInfoMap;
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{PcePathInfo.class}).register(new Class[]{ExplicitPathInfo.class}).register(new Class[]{ExplicitPathInfo.Type.class}).register(new Class[]{CostConstraint.class}).register(new Class[]{CostConstraint.Type.class}).register(new Class[]{PceBandwidthConstraint.class}).register(new Class[]{SharedBandwidthConstraint.class}).register(new Class[]{CapabilityConstraint.class}).register(new Class[]{CapabilityConstraint.CapabilityType.class}).register(new Class[]{LspType.class}).build());

    @Activate
    protected void activate() {
        this.failedPathSet = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("failed-path-info")).withSerializer(SERIALIZER)).build()).asDistributedSet();
        this.tunnelNameExplicitPathInfoMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-explicitpathinfo")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{ExplicitPathInfo.class}).register(new Class[]{ExplicitPathInfo.Type.class}).build()))).build();
        this.tunnelNameDisjoinTunnelIdInfo = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-disjointTunnelIds")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{TunnelId.class}).build()))).build();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public boolean existsFailedPathInfo(PcePathInfo failedPathInfo) {
        Preconditions.checkNotNull((Object)failedPathInfo, (Object)PATH_INFO_NULL);
        return this.failedPathSet.contains((Object)failedPathInfo);
    }

    @Override
    public int getFailedPathInfoCount() {
        return this.failedPathSet.size();
    }

    @Override
    public Iterable<PcePathInfo> getFailedPathInfos() {
        return ImmutableSet.copyOf(this.failedPathSet);
    }

    @Override
    public void addFailedPathInfo(PcePathInfo failedPathInfo) {
        Preconditions.checkNotNull((Object)failedPathInfo, (Object)PATH_INFO_NULL);
        this.failedPathSet.add((Object)failedPathInfo);
    }

    @Override
    public boolean removeFailedPathInfo(PcePathInfo failedPathInfo) {
        Preconditions.checkNotNull((Object)failedPathInfo, (Object)PATH_INFO_NULL);
        if (!this.failedPathSet.remove((Object)failedPathInfo)) {
            this.log.error("Failed path info {} deletion has failed.", (Object)failedPathInfo.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean tunnelNameExplicitPathInfoMap(String tunnelName, List<ExplicitPathInfo> explicitPathInfo) {
        Preconditions.checkNotNull((Object)tunnelName);
        Preconditions.checkNotNull(explicitPathInfo);
        return this.tunnelNameExplicitPathInfoMap.put((Object)tunnelName, explicitPathInfo) != null;
    }

    @Override
    public List<ExplicitPathInfo> getTunnelNameExplicitPathInfoMap(String tunnelName) {
        Preconditions.checkNotNull((Object)tunnelName);
        if (this.tunnelNameExplicitPathInfoMap.get((Object)tunnelName) != null) {
            return (List)this.tunnelNameExplicitPathInfoMap.get((Object)tunnelName).value();
        }
        return null;
    }

    @Override
    public boolean addLoadBalancingTunnelIdsInfo(String tunnelName, TunnelId ... tunnelIds) {
        Preconditions.checkNotNull((Object)tunnelName);
        Preconditions.checkNotNull((Object)tunnelIds);
        return this.tunnelNameDisjoinTunnelIdInfo.put((Object)tunnelName, Arrays.asList(tunnelIds)) != null;
    }

    @Override
    public List<TunnelId> getLoadBalancingTunnelIds(String tunnelName) {
        if (this.tunnelNameDisjoinTunnelIdInfo.get((Object)tunnelName) != null) {
            return (List)this.tunnelNameDisjoinTunnelIdInfo.get((Object)tunnelName).value();
        }
        return null;
    }

    @Override
    public boolean removeLoadBalancingTunnelIdsInfo(String tunnelName) {
        if (this.tunnelNameDisjoinTunnelIdInfo.remove((Object)tunnelName) == null) {
            this.log.error("Failed to remove entry {} for this tunnelName in DisjointTunnelIdsInfoMap" + tunnelName);
            return false;
        }
        return true;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

