/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice.constraint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.util.Bandwidth;
import org.onlab.util.DataRateUnit;
import org.onosproject.bandwidthmgr.api.BandwidthMgmtService;
import org.onosproject.net.Link;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.BooleanConstraint;

public final class PceBandwidthConstraint
extends BooleanConstraint {
    private final Bandwidth bandwidth;

    public PceBandwidthConstraint(Bandwidth bandwidth) {
        this.bandwidth = (Bandwidth)Preconditions.checkNotNull((Object)bandwidth, (Object)"Bandwidth cannot be null");
    }

    public static PceBandwidthConstraint of(double v, DataRateUnit unit) {
        return new PceBandwidthConstraint(Bandwidth.of((double)v, (DataRateUnit)unit));
    }

    private PceBandwidthConstraint() {
        this.bandwidth = null;
    }

    public boolean isValid(Link link, ResourceContext context) {
        return false;
    }

    public boolean isValidLink(Link link, BandwidthMgmtService bandwidthMgmtService) {
        if (bandwidthMgmtService == null) {
            return false;
        }
        return bandwidthMgmtService.isBandwidthAvailable(link, Double.valueOf(this.bandwidth.bps()));
    }

    public Bandwidth bandwidth() {
        return this.bandwidth;
    }

    public int hashCode() {
        return this.bandwidth.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        PceBandwidthConstraint other = (PceBandwidthConstraint)((Object)obj);
        return Objects.equals(this.bandwidth, other.bandwidth);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("bandwidth", (Object)this.bandwidth).toString();
    }
}

