/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice.constraint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.Path;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.pcep.api.TeLinkConfig;

public final class CostConstraint
implements Constraint {
    private final Type type;
    public static final String TE_COST = "teCost";
    public static final String COST = "cost";

    private CostConstraint() {
        this.type = null;
    }

    public CostConstraint(Type type) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Type cannot be null"));
    }

    public static CostConstraint of(Type type) {
        return new CostConstraint(type);
    }

    public Type type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CostConstraint) {
            CostConstraint other = (CostConstraint)obj;
            return Objects.equals((Object)this.type, (Object)other.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }

    public double cost(Link link, ResourceContext context) {
        return 0.0;
    }

    public double isValidLink(Link link, NetworkConfigService netCfgService) {
        if (netCfgService == null) {
            return -1.0;
        }
        TeLinkConfig cfg = (TeLinkConfig)netCfgService.getConfig((Object)LinkKey.linkKey((ConnectPoint)link.src(), (ConnectPoint)link.dst()), TeLinkConfig.class);
        if (cfg == null) {
            return -1.0;
        }
        switch (this.type) {
            case COST: {
                return cfg.igpCost() == 0 ? -1.0 : (double)cfg.igpCost();
            }
            case TE_COST: {
                return cfg.teCost() == 0 ? -1.0 : (double)cfg.teCost();
            }
        }
        return -1.0;
    }

    public boolean validate(Path path, ResourceContext context) {
        return false;
    }

    public static enum Type {
        COST(1),
        TE_COST(2);

        int value;

        private Type(int val) {
            this.value = val;
        }

        public byte type() {
            return (byte)this.value;
        }
    }
}

