/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.util.Bandwidth;
import org.onlab.util.KryoNamespace;
import org.onosproject.bandwidthmgr.api.BandwidthMgmtService;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelEvent;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelListener;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.pce.pceservice.ExplicitPathInfo;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.pce.pceservice.constraint.CapabilityConstraint;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pceservice.constraint.PceBandwidthConstraint;
import org.onosproject.pce.pceservice.constraint.SharedBandwidthConstraint;
import org.onosproject.pce.pcestore.PcePathInfo;
import org.onosproject.pce.pcestore.api.PceStore;
import org.onosproject.pcep.api.DeviceCapability;
import org.onosproject.pcep.api.TeLinkConfig;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PceManager
implements PceService {
    private static final Logger log = LoggerFactory.getLogger(PceManager.class);
    public static final long GLOBAL_LABEL_SPACE_MIN = 4097L;
    public static final long GLOBAL_LABEL_SPACE_MAX = 5121L;
    public static final String PCE_SERVICE_APP = "org.onosproject.pce";
    private static final String LOCAL_LSP_ID_GEN_TOPIC = "pcep-local-lsp-id";
    public static final String DEVICE_TYPE = "type";
    public static final String L3_DEVICE = "L3";
    private static final String LSRID = "lsrId";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final int PCEP_PORT = 4189;
    private IdGenerator localLspIdIdGen;
    protected DistributedSet<Short> localLspIdFreeList;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PathService pathService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PceStore pceStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelService tunnelService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService netCfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected BandwidthMgmtService bandwidthMgmtService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry netConfigRegistry;
    private TunnelListener listener = new InnerTunnelListener();
    private ApplicationId appId;
    private final TopologyListener topologyListener = new InternalTopologyListener();
    public static final String LOAD_BALANCING_PATH_NAME = "loadBalancingPathName";
    private List<TunnelId> rsvpTunnelsWithLocalBw = new ArrayList<TunnelId>();
    private final ConfigFactory<LinkKey, TeLinkConfig> configFactory = new ConfigFactory<LinkKey, TeLinkConfig>(SubjectFactories.LINK_SUBJECT_FACTORY, TeLinkConfig.class, "teLinkConfig"){

        public TeLinkConfig createConfig() {
            return new TeLinkConfig();
        }
    };

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(PCE_SERVICE_APP);
        this.tunnelService.addListener((EventListener)this.listener);
        this.localLspIdIdGen = this.coreService.getIdGenerator(LOCAL_LSP_ID_GEN_TOPIC);
        this.localLspIdIdGen.getNewId();
        this.localLspIdFreeList = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("pcepLocalLspIdDeletedList")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build()).asDistributedSet();
        this.topologyService.addListener((EventListener)this.topologyListener);
        this.netConfigRegistry.registerConfigFactory(this.configFactory);
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.tunnelService.removeListener((EventListener)this.listener);
        this.topologyService.removeListener((EventListener)this.topologyListener);
        this.netConfigRegistry.unregisterConfigFactory(this.configFactory);
        log.info("Stopped");
    }

    private LinkWeight weight(List<Constraint> constraints) {
        return new TeConstraintBasedLinkWeight(constraints);
    }

    protected Set<Path> computePath(DeviceId src, DeviceId dst, List<Constraint> constraints) {
        if (this.pathService == null) {
            return ImmutableSet.of();
        }
        Set paths = this.pathService.getPaths((ElementId)src, (ElementId)dst, this.weight(constraints));
        log.info("paths in computePath ::" + paths);
        if (!paths.isEmpty()) {
            return paths;
        }
        return ImmutableSet.of();
    }

    private List<Path> computePartialPath(List<Path> computedPath, DeviceId src, DeviceId dst, List<Constraint> constraints) {
        int size = computedPath.size();
        Path path = null;
        DeviceId deviceId = size == 0 ? src : computedPath.get(size - 1).dst().deviceId();
        Set<Path> tempComputePath = this.computePath(deviceId, dst, constraints);
        if (tempComputePath.isEmpty()) {
            return null;
        }
        for (Path p : tempComputePath) {
            if (!this.pathValidation(computedPath, p)) continue;
            path = p;
            break;
        }
        if (path == null) {
            return null;
        }
        computedPath.add(path);
        return computedPath;
    }

    private List<DeviceId> createListOfDeviceIds(List<? extends NetworkResource> list) {
        LinkedList<? extends NetworkResource> links = new LinkedList<NetworkResource>();
        if (!list.isEmpty() && list.iterator().next() instanceof Path) {
            for (Path path : list) {
                links.addAll(path.links());
            }
        } else if (!list.isEmpty() && list.iterator().next() instanceof Link) {
            links.addAll(list);
        }
        Object source = null;
        Object var4_5 = null;
        LinkedList<DeviceId> devList = new LinkedList<DeviceId>();
        for (Link link : links) {
            if (!devList.contains(link.src().deviceId())) {
                devList.add(link.src().deviceId());
            }
            if (devList.contains(link.dst().deviceId())) continue;
            devList.add(link.dst().deviceId());
        }
        return devList;
    }

    private boolean pathValidation(List<Path> partialPath, Path path) {
        List<DeviceId> newPartialPathDevList = this.createListOfDeviceIds(path.links());
        List<DeviceId> partialComputedPathDevList = this.createListOfDeviceIds(partialPath);
        for (DeviceId deviceId : newPartialPathDevList) {
            for (DeviceId devId : partialComputedPathDevList) {
                if (newPartialPathDevList.get(0).equals((Object)deviceId) || partialComputedPathDevList.get(partialComputedPathDevList.size() - 1).equals((Object)devId) || !deviceId.equals((Object)devId)) continue;
                return false;
            }
        }
        return true;
    }

    private List<Path> computeExplicitPath(List<ExplicitPathInfo> explicitPathInfo, DeviceId src, DeviceId dst, List<Constraint> constraints) {
        List<Path> finalComputedPath = new LinkedList<Path>();
        for (ExplicitPathInfo info : explicitPathInfo) {
            if (info.type().equals((Object)ExplicitPathInfo.Type.LOOSE)) {
                if (info.value() instanceof DeviceId) {
                    if (!info.value().equals(src)) {
                        log.debug("computeExplicitPath :: Loose , device");
                        finalComputedPath = this.computePartialPath(finalComputedPath, src, (DeviceId)info.value(), constraints);
                        log.debug("finalComputedPath in computeExplicitPath ::" + finalComputedPath);
                    }
                } else if (info.value() instanceof Link) {
                    finalComputedPath = ((Link)info.value()).src().deviceId().equals((Object)src) || !finalComputedPath.isEmpty() && finalComputedPath.get(finalComputedPath.size() - 1).dst().deviceId().equals((Object)((Link)info.value()).src().deviceId()) ? this.computePartialPath(finalComputedPath, src, ((Link)info.value()).dst().deviceId(), constraints) : (this.computePartialPath(finalComputedPath, src, ((Link)info.value()).src().deviceId(), constraints) != null ? this.computePartialPath(finalComputedPath, src, ((Link)info.value()).dst().deviceId(), constraints) : null);
                }
            } else if (info.type().equals((Object)ExplicitPathInfo.Type.STRICT)) {
                if (info.value() instanceof DeviceId) {
                    log.debug("computeExplicitPath :: Strict , device");
                    if (!(!finalComputedPath.isEmpty() && finalComputedPath.get(finalComputedPath.size() - 1).dst().deviceId().equals((Object)info.value()) || info.value().equals(src))) {
                        finalComputedPath = null;
                    }
                } else if (info.value() instanceof Link) {
                    log.info("computeExplicitPath :: Strict");
                    List<Path> list = finalComputedPath = ((Link)info.value()).src().deviceId().equals((Object)src) || !finalComputedPath.isEmpty() && finalComputedPath.get(finalComputedPath.size() - 1).dst().deviceId().equals((Object)((Link)info.value()).src().deviceId()) ? this.computePartialPath(finalComputedPath, src, ((Link)info.value()).dst().deviceId(), constraints) : null;
                    if (finalComputedPath != null && !finalComputedPath.get(finalComputedPath.size() - 1).links().contains((Link)info.value())) {
                        finalComputedPath = null;
                    }
                }
            }
            if (finalComputedPath != null) continue;
            return null;
        }
        if ((finalComputedPath.isEmpty() || !finalComputedPath.isEmpty() && !((Path)finalComputedPath.get(finalComputedPath.size() - 1)).dst().deviceId().equals((Object)dst)) && (finalComputedPath = this.computePartialPath(finalComputedPath, src, dst, constraints)) == null) {
            return null;
        }
        return finalComputedPath;
    }

    @Override
    public boolean setupPath(DeviceId src, DeviceId dst, String tunnelName, List<Constraint> constraints, LspType lspType) {
        return this.setupPath(src, dst, tunnelName, constraints, lspType, null, false);
    }

    @Override
    public boolean setupPath(DeviceId src, DeviceId dst, String tunnelName, List<Constraint> constraints, LspType lspType, List<ExplicitPathInfo> explicitPathInfo) {
        return this.setupPath(src, dst, tunnelName, constraints, lspType, explicitPathInfo, false);
    }

    @Override
    public boolean setupPath(DeviceId src, DeviceId dst, String tunnelName, List<Constraint> constraints, LspType lspType, boolean loadBalancing) {
        return this.setupPath(src, dst, tunnelName, constraints, lspType, null, loadBalancing);
    }

    @Override
    public boolean setupPath(DeviceId src, DeviceId dst, String tunnelName, List<Constraint> constraints, LspType lspType, List<ExplicitPathInfo> explicitPathInfo, boolean loadBalancing) {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dst);
        Preconditions.checkNotNull((Object)tunnelName);
        Preconditions.checkNotNull((Object)((Object)lspType));
        Device srcDevice = this.deviceService.getDevice(src);
        Device dstDevice = this.deviceService.getDevice(dst);
        if (srcDevice == null || dstDevice == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, explicitPathInfo, loadBalancing));
            return false;
        }
        String srcLsrId = srcDevice.annotations().value(LSRID);
        String dstLsrId = dstDevice.annotations().value(LSRID);
        if (srcLsrId == null || dstLsrId == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, explicitPathInfo, loadBalancing));
            return false;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)srcLsrId), DeviceCapability.class);
        if (cfg == null) {
            log.debug("No session to ingress.");
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, explicitPathInfo, loadBalancing));
            return false;
        }
        IpTunnelEndPoint srcEndPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)srcLsrId));
        IpTunnelEndPoint dstEndPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)dstLsrId));
        double bwConstraintValue = 0.0;
        CostConstraint costConstraint = null;
        if (constraints != null) {
            constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(lspType.name())));
            for (Constraint constraint : constraints) {
                if (constraint instanceof PceBandwidthConstraint) {
                    bwConstraintValue = ((PceBandwidthConstraint)constraint).bandwidth().bps();
                    continue;
                }
                if (!(constraint instanceof CostConstraint)) continue;
                costConstraint = (CostConstraint)constraint;
            }
            if (costConstraint != null) {
                constraints.remove(costConstraint);
                constraints.add(costConstraint);
            }
        } else {
            constraints = new LinkedList<Constraint>();
            constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(lspType.name())));
        }
        Set<Object> computedPathSet = Sets.newLinkedHashSet();
        if (loadBalancing) {
            return this.setupDisjointPaths(src, dst, constraints, tunnelName, bwConstraintValue, lspType, costConstraint, (TunnelEndPoint)srcEndPoint, (TunnelEndPoint)dstEndPoint);
        }
        if (explicitPathInfo != null && !explicitPathInfo.isEmpty()) {
            List<Path> finalComputedPath = this.computeExplicitPath(explicitPathInfo, src, dst, constraints);
            if (finalComputedPath == null) {
                return false;
            }
            this.pceStore.tunnelNameExplicitPathInfoMap(tunnelName, explicitPathInfo);
            LinkedList links = new LinkedList();
            double totalCost = 0.0;
            for (Path path : finalComputedPath) {
                links.addAll(path.links());
                totalCost += path.cost();
            }
            computedPathSet.add(new DefaultPath(finalComputedPath.iterator().next().providerId(), links, totalCost, new Annotations[0]));
        } else {
            computedPathSet = this.computePath(src, dst, constraints);
        }
        if (computedPathSet.isEmpty()) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, explicitPathInfo, loadBalancing));
            return false;
        }
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        if (bwConstraintValue != 0.0) {
            annotationBuilder.set("bandwidth", String.valueOf(bwConstraintValue));
        }
        if (costConstraint != null) {
            annotationBuilder.set("costType", String.valueOf((Object)costConstraint.type()));
        }
        annotationBuilder.set("lspSigType", lspType.name());
        annotationBuilder.set("pceInit", TRUE);
        annotationBuilder.set("delegate", TRUE);
        Path computedPath = (Path)computedPathSet.iterator().next();
        if (lspType != LspType.WITH_SIGNALLING) {
            annotationBuilder.set("localLspId", String.valueOf(this.getNextLocalLspId()));
        }
        DefaultTunnel tunnel = new DefaultTunnel(null, (TunnelEndPoint)srcEndPoint, (TunnelEndPoint)dstEndPoint, Tunnel.Type.MPLS, Tunnel.State.INIT, null, null, TunnelName.tunnelName((String)tunnelName), computedPath, new Annotations[]{annotationBuilder.build()});
        if (bwConstraintValue != 0.0 && !this.reserveBandwidth(computedPath, bwConstraintValue, null)) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, explicitPathInfo, loadBalancing));
            return false;
        }
        TunnelId tunnelId = this.tunnelService.setupTunnel(this.appId, (ElementId)src, (Tunnel)tunnel, computedPath);
        if (tunnelId == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, explicitPathInfo, loadBalancing));
            if (bwConstraintValue != 0.0) {
                computedPath.links().forEach(arg_0 -> this.lambda$setupPath$0((Tunnel)tunnel, arg_0));
            }
            return false;
        }
        if (bwConstraintValue != 0.0 && lspType == LspType.WITH_SIGNALLING) {
            this.rsvpTunnelsWithLocalBw.add(tunnelId);
        }
        return true;
    }

    private boolean setupDisjointPaths(DeviceId src, DeviceId dst, List<Constraint> constraints, String tunnelName, double bwConstraintValue, LspType lspType, CostConstraint costConstraint, TunnelEndPoint srcEndPoint, TunnelEndPoint dstEndPoint) {
        TunnelId tunnelId1;
        Set paths = this.pathService.getDisjointPaths((ElementId)src, (ElementId)dst, this.weight(constraints));
        if (paths.isEmpty()) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, null, true));
            return false;
        }
        DisjointPath path = null;
        if (!paths.isEmpty()) {
            path = (DisjointPath)paths.iterator().next();
        }
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        double bw = 0.0;
        if (bwConstraintValue != 0.0) {
            bw = bwConstraintValue / 2.0;
            annotationBuilder.set("bandwidth", String.valueOf(bw));
        }
        if (costConstraint != null) {
            annotationBuilder.set("costType", String.valueOf((Object)costConstraint.type()));
        }
        annotationBuilder.set("lspSigType", lspType.name());
        annotationBuilder.set("pceInit", TRUE);
        annotationBuilder.set("delegate", TRUE);
        annotationBuilder.set(LOAD_BALANCING_PATH_NAME, tunnelName);
        if (lspType != LspType.WITH_SIGNALLING) {
            annotationBuilder.set("localLspId", String.valueOf(this.getNextLocalLspId()));
        }
        String tunnel1 = tunnelName + "_1";
        String tunnel2 = tunnelName + "_2";
        DefaultTunnel tunnelPrimary = new DefaultTunnel(null, srcEndPoint, dstEndPoint, Tunnel.Type.MPLS, Tunnel.State.INIT, null, null, TunnelName.tunnelName((String)tunnel1), path.primary(), new Annotations[]{annotationBuilder.build()});
        DefaultTunnel tunnelBackup = new DefaultTunnel(null, srcEndPoint, dstEndPoint, Tunnel.Type.MPLS, Tunnel.State.INIT, null, null, TunnelName.tunnelName((String)tunnel2), path.backup(), new Annotations[]{annotationBuilder.build()});
        if (bwConstraintValue != 0.0) {
            if (!this.reserveBandwidth(path.primary(), bw, null)) {
                this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnel1, constraints, lspType, null, true));
                return false;
            }
            if (!this.reserveBandwidth(path.backup(), bw, null)) {
                if (bwConstraintValue != 0.0) {
                    path.primary().links().forEach(arg_0 -> this.lambda$setupDisjointPaths$1((Tunnel)tunnelPrimary, arg_0));
                }
                this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnel2, constraints, lspType, null, true));
                return false;
            }
        }
        if ((tunnelId1 = this.tunnelService.setupTunnel(this.appId, (ElementId)src, (Tunnel)tunnelPrimary, path.primary())) == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, null, true));
            if (bwConstraintValue != 0.0) {
                path.primary().links().forEach(arg_0 -> this.lambda$setupDisjointPaths$2((Tunnel)tunnelPrimary, arg_0));
            }
            return false;
        }
        TunnelId tunnelId2 = this.tunnelService.setupTunnel(this.appId, (ElementId)src, (Tunnel)tunnelBackup, path.backup());
        if (tunnelId2 == null) {
            this.releasePath(tunnelId1);
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType, null, true));
            if (bwConstraintValue != 0.0) {
                path.backup().links().forEach(arg_0 -> this.lambda$setupDisjointPaths$3((Tunnel)tunnelBackup, arg_0));
            }
            return false;
        }
        this.pceStore.addLoadBalancingTunnelIdsInfo(tunnelName, tunnelId1, tunnelId2);
        return true;
    }

    @Override
    public boolean updatePath(TunnelId tunnelId, List<Constraint> constraints) {
        Preconditions.checkNotNull((Object)tunnelId);
        Set<Object> computedPathSet = Sets.newLinkedHashSet();
        Tunnel tunnel = this.tunnelService.queryTunnel(tunnelId);
        if (tunnel == null) {
            return false;
        }
        if (tunnel.type() != Tunnel.Type.MPLS || FALSE.equalsIgnoreCase(tunnel.annotations().value("delegate"))) {
            return false;
        }
        List links = tunnel.path().links();
        String lspSigType = tunnel.annotations().value("lspSigType");
        double bwConstraintValue = 0.0;
        String costType = null;
        SharedBandwidthConstraint shBwConstraint = null;
        PceBandwidthConstraint bwConstraint = null;
        CostConstraint costConstraint = null;
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                if (constraint instanceof PceBandwidthConstraint) {
                    bwConstraint = (PceBandwidthConstraint)constraint;
                    bwConstraintValue = bwConstraint.bandwidth().bps();
                    continue;
                }
                if (!(constraint instanceof CostConstraint)) continue;
                costConstraint = (CostConstraint)constraint;
                costType = costConstraint.type().name();
            }
            if (costConstraint != null) {
                constraints.remove(costConstraint);
            }
            Bandwidth existingBwValue = null;
            String existingBwAnnotation = tunnel.annotations().value("bandwidth");
            if (existingBwAnnotation != null) {
                existingBwValue = Bandwidth.bps((double)Double.parseDouble(existingBwAnnotation));
                if (bwConstraint != null) {
                    constraints.remove((Object)bwConstraint);
                }
            }
            if (existingBwValue != null) {
                if (bwConstraint == null) {
                    bwConstraintValue = existingBwValue.bps();
                }
                shBwConstraint = bwConstraint != null ? new SharedBandwidthConstraint(links, existingBwValue, bwConstraint.bandwidth()) : new SharedBandwidthConstraint(links, existingBwValue, existingBwValue);
                constraints.add((Constraint)shBwConstraint);
            }
        } else {
            constraints = new LinkedList<Constraint>();
        }
        constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(lspSigType)));
        if (costConstraint != null) {
            constraints.add(costConstraint);
        } else {
            costType = tunnel.annotations().value("costType");
            costConstraint = CostConstraint.of(CostConstraint.Type.valueOf(costType));
            constraints.add(costConstraint);
        }
        List<ExplicitPathInfo> explicitPathInfo = this.pceStore.getTunnelNameExplicitPathInfoMap(tunnel.tunnelName().value());
        if (explicitPathInfo != null) {
            List<Path> finalComputedPath = this.computeExplicitPath(explicitPathInfo, tunnel.path().src().deviceId(), tunnel.path().dst().deviceId(), constraints);
            if (finalComputedPath == null) {
                return false;
            }
            LinkedList totalLinks = new LinkedList();
            double totalCost = 0.0;
            for (Path path : finalComputedPath) {
                totalLinks.addAll(path.links());
                totalCost += path.cost();
            }
            computedPathSet.add(new DefaultPath(finalComputedPath.iterator().next().providerId(), totalLinks, totalCost, new Annotations[0]));
        } else {
            computedPathSet = this.computePath(tunnel.path().src().deviceId(), tunnel.path().dst().deviceId(), constraints);
        }
        if (computedPathSet.isEmpty()) {
            return false;
        }
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        annotationBuilder.set("bandwidth", String.valueOf(bwConstraintValue));
        if (costType != null) {
            annotationBuilder.set("costType", costType);
        }
        annotationBuilder.set("lspSigType", lspSigType);
        annotationBuilder.set("pceInit", TRUE);
        annotationBuilder.set("delegate", TRUE);
        annotationBuilder.set("PLspId", tunnel.annotations().value("PLspId"));
        annotationBuilder.set("PccTunnelId", tunnel.annotations().value("PccTunnelId"));
        Path computedPath = (Path)computedPathSet.iterator().next();
        LspType lspType = LspType.valueOf(lspSigType);
        long localLspId = 0L;
        if (lspType != LspType.WITH_SIGNALLING) {
            localLspId = this.getNextLocalLspId();
            annotationBuilder.set("localLspId", String.valueOf(localLspId));
        }
        DefaultTunnel updatedTunnel = new DefaultTunnel(null, tunnel.src(), tunnel.dst(), Tunnel.Type.MPLS, Tunnel.State.INIT, null, null, tunnel.tunnelName(), computedPath, new Annotations[]{annotationBuilder.build()});
        if (bwConstraintValue != 0.0 && !this.reserveBandwidth(computedPath, bwConstraintValue, shBwConstraint)) {
            return false;
        }
        TunnelId updatedTunnelId = this.tunnelService.setupTunnel(this.appId, (ElementId)((Link)links.get(0)).src().deviceId(), (Tunnel)updatedTunnel, computedPath);
        if (updatedTunnelId == null) {
            if (bwConstraintValue != 0.0) {
                this.releaseSharedBwForNewTunnel(computedPath, bwConstraintValue, shBwConstraint);
            }
            return false;
        }
        if (bwConstraintValue != 0.0 && lspType == LspType.WITH_SIGNALLING) {
            this.rsvpTunnelsWithLocalBw.add(updatedTunnelId);
        }
        return true;
    }

    @Override
    public boolean releasePath(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId);
        Tunnel tunnel = this.tunnelService.queryTunnel(tunnelId);
        if (tunnel == null) {
            return false;
        }
        return this.tunnelService.downTunnel(this.appId, tunnel.tunnelId());
    }

    @Override
    public boolean releasePath(String loadBalancingPathName) {
        Preconditions.checkNotNull((Object)loadBalancingPathName);
        List<TunnelId> tunnelIds = this.pceStore.getLoadBalancingTunnelIds(loadBalancingPathName);
        if (tunnelIds != null && !tunnelIds.isEmpty()) {
            for (TunnelId id : tunnelIds) {
                if (this.tunnelService.downTunnel(this.appId, id)) continue;
                return false;
            }
            this.pceStore.removeLoadBalancingTunnelIdsInfo(loadBalancingPathName);
            return true;
        }
        return false;
    }

    @Override
    public Iterable<Tunnel> queryAllPath() {
        return this.tunnelService.queryTunnel(Tunnel.Type.MPLS);
    }

    @Override
    public Tunnel queryPath(TunnelId tunnelId) {
        return this.tunnelService.queryTunnel(tunnelId);
    }

    private boolean releaseSharedBwForNewTunnel(Path computedPath, double bandwidthConstraint, SharedBandwidthConstraint shBwConstraint) {
        Preconditions.checkNotNull((Object)computedPath);
        Preconditions.checkNotNull((Object)bandwidthConstraint);
        Double additionalBwValue = null;
        if (shBwConstraint != null) {
            additionalBwValue = bandwidthConstraint - shBwConstraint.sharedBwValue().bps() <= 0.0 ? null : Double.valueOf(bandwidthConstraint - shBwConstraint.sharedBwValue().bps());
        }
        for (Link link : computedPath.links()) {
            double bwToAllocate = 0.0;
            if (shBwConstraint != null && shBwConstraint.links().contains(link)) {
                if (additionalBwValue != null) {
                    bwToAllocate = additionalBwValue;
                }
            } else {
                bwToAllocate = bandwidthConstraint;
            }
            if (bwToAllocate == 0.0) continue;
            this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)link), Double.valueOf(bwToAllocate));
        }
        return true;
    }

    private synchronized short getNextLocalLspId() {
        if (this.localLspIdFreeList.isEmpty()) {
            return (short)this.localLspIdIdGen.getNewId();
        }
        Iterator it = this.localLspIdFreeList.iterator();
        Short value = (Short)it.next();
        this.localLspIdFreeList.remove((Object)value);
        return value;
    }

    private boolean checkForMasterAndUpdateTunnel(DeviceId src, Tunnel tunnel) {
        if (this.mastershipService.isLocalMaster(src) && Boolean.valueOf(tunnel.annotations().value("delegate")) != null) {
            LinkedList<Constraint> constraintList = new LinkedList<Constraint>();
            if (tunnel.annotations().value("bandwidth") != null) {
                PceBandwidthConstraint localConst = new PceBandwidthConstraint(Bandwidth.bps((double)Double.parseDouble(tunnel.annotations().value("bandwidth"))));
                constraintList.add((Constraint)localConst);
            }
            if (tunnel.annotations().value("costType") != null) {
                constraintList.add(CostConstraint.of(CostConstraint.Type.valueOf(tunnel.annotations().value("costType"))));
            }
            if (!this.updatePath(tunnel.tunnelId(), constraintList) && !tunnel.state().equals((Object)Tunnel.State.FAILED)) {
                this.pceStore.addFailedPathInfo(new PcePathInfo(tunnel.path().src().deviceId(), tunnel.path().dst().deviceId(), tunnel.tunnelName().value(), constraintList, LspType.valueOf(tunnel.annotations().value("lspSigType")), this.pceStore.getTunnelNameExplicitPathInfoMap(tunnel.tunnelName().value()), tunnel.annotations().value(LOAD_BALANCING_PATH_NAME) != null));
                this.releasePath(tunnel.tunnelId());
            }
        }
        return false;
    }

    private boolean reserveBandwidth(Path computedPath, double bandwidthConstraint, SharedBandwidthConstraint shBwConstraint) {
        Preconditions.checkNotNull((Object)computedPath);
        Preconditions.checkNotNull((Object)bandwidthConstraint);
        Object resource = null;
        double bwToAllocate = 0.0;
        HashMap<Link, Double> linkMap = new HashMap<Link, Double>();
        Double additionalBwValue = null;
        if (shBwConstraint != null) {
            additionalBwValue = bandwidthConstraint - shBwConstraint.sharedBwValue().bps() <= 0.0 ? null : Double.valueOf(bandwidthConstraint - shBwConstraint.sharedBwValue().bps());
        }
        Object resAlloc = null;
        for (Link link : computedPath.links()) {
            bwToAllocate = 0.0;
            if (shBwConstraint != null && shBwConstraint.links().contains(link)) {
                if (additionalBwValue != null) {
                    bwToAllocate = additionalBwValue;
                }
            } else {
                bwToAllocate = bandwidthConstraint;
            }
            if (bwToAllocate == 0.0) continue;
            if (!this.bandwidthMgmtService.allocLocalReservedBw(LinkKey.linkKey((ConnectPoint)link.src(), (ConnectPoint)link.dst()), Double.valueOf(bwToAllocate))) {
                linkMap.forEach((ln, aDouble) -> this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)ln), aDouble));
                return false;
            }
            linkMap.put(link, bwToAllocate);
        }
        return true;
    }

    private void releaseBandwidth(Tunnel tunnel) {
        Collection tunnelQueryResult = this.tunnelService.queryTunnel(tunnel.src(), tunnel.dst());
        Tunnel newTunnel = null;
        for (Tunnel tunnelObj : tunnelQueryResult) {
            if (!tunnel.tunnelName().value().equals(tunnelObj.tunnelName().value())) continue;
            newTunnel = tunnelObj;
            break;
        }
        boolean isLinkShared = false;
        if (newTunnel != null) {
            for (Link link : tunnel.path().links()) {
                if (!newTunnel.path().links().contains(link)) continue;
                isLinkShared = true;
                break;
            }
        }
        if (isLinkShared) {
            this.releaseSharedBandwidth(newTunnel, tunnel);
            return;
        }
        tunnel.path().links().forEach(tn -> this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)tn), Double.valueOf(Double.parseDouble(tunnel.annotations().value("bandwidth")))));
    }

    private synchronized void releaseSharedBandwidth(Tunnel newTunnel, Tunnel oldTunnel) {
        boolean isAllocate = false;
        Double oldTunnelBw = Double.parseDouble(oldTunnel.annotations().value("bandwidth"));
        Double newTunnelBw = Double.parseDouble(newTunnel.annotations().value("bandwidth"));
        if (newTunnelBw > oldTunnelBw) {
            isAllocate = true;
        }
        for (Link link : newTunnel.path().links()) {
            if (oldTunnel.path().links().contains(link)) {
                if (isAllocate) continue;
                this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)link), Double.valueOf(oldTunnelBw - newTunnelBw));
                continue;
            }
            this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)link), oldTunnelBw);
        }
    }

    @Override
    public List<ExplicitPathInfo> explicitPathInfoList(String tunnelName) {
        return this.pceStore.getTunnelNameExplicitPathInfoMap(tunnelName);
    }

    @Override
    public List<TunnelId> queryLoadBalancingPath(String pathName) {
        return this.pceStore.getLoadBalancingTunnelIds(pathName);
    }

    private void callForOptimization() {
        for (PcePathInfo failedPathInfo : this.pceStore.getFailedPathInfos()) {
            this.checkForMasterAndSetupPath(failedPathInfo);
        }
        this.tunnelService.queryTunnel(Tunnel.Type.MPLS).forEach(t -> this.checkForMasterAndUpdateTunnel(t.path().src().deviceId(), (Tunnel)t));
    }

    private boolean checkForMasterAndSetupPath(PcePathInfo failedPathInfo) {
        if (this.mastershipService.isLocalMaster(failedPathInfo.src()) && this.setupPath(failedPathInfo.src(), failedPathInfo.dst(), failedPathInfo.name(), failedPathInfo.constraints(), failedPathInfo.lspType(), failedPathInfo.explicitPathInfo())) {
            this.pceStore.removeFailedPathInfo(failedPathInfo);
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$setupDisjointPaths$3(Tunnel tunnelBackup, Link ln) {
        this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)ln), Double.valueOf(Double.parseDouble(tunnelBackup.annotations().value("bandwidth"))));
    }

    private /* synthetic */ void lambda$setupDisjointPaths$2(Tunnel tunnelPrimary, Link ln) {
        this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)ln), Double.valueOf(Double.parseDouble(tunnelPrimary.annotations().value("bandwidth"))));
    }

    private /* synthetic */ void lambda$setupDisjointPaths$1(Tunnel tunnelPrimary, Link ln) {
        this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)ln), Double.valueOf(Double.parseDouble(tunnelPrimary.annotations().value("bandwidth"))));
    }

    private /* synthetic */ void lambda$setupPath$0(Tunnel tunnel, Link ln) {
        this.bandwidthMgmtService.releaseLocalReservedBw(LinkKey.linkKey((Link)ln), Double.valueOf(Double.parseDouble(tunnel.annotations().value("bandwidth"))));
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPathService(PathService pathService) {
        this.pathService = pathService;
    }

    protected void unbindPathService(PathService pathService) {
        if (this.pathService == pathService) {
            this.pathService = null;
        }
    }

    protected void bindPceStore(PceStore pceStore) {
        this.pceStore = pceStore;
    }

    protected void unbindPceStore(PceStore pceStore) {
        if (this.pceStore == pceStore) {
            this.pceStore = null;
        }
    }

    protected void bindTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    protected void unbindTunnelService(TunnelService tunnelService) {
        if (this.tunnelService == tunnelService) {
            this.tunnelService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindNetCfgService(NetworkConfigService networkConfigService) {
        this.netCfgService = networkConfigService;
    }

    protected void unbindNetCfgService(NetworkConfigService networkConfigService) {
        if (this.netCfgService == networkConfigService) {
            this.netCfgService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    protected void bindBandwidthMgmtService(BandwidthMgmtService bandwidthMgmtService) {
        this.bandwidthMgmtService = bandwidthMgmtService;
    }

    protected void unbindBandwidthMgmtService(BandwidthMgmtService bandwidthMgmtService) {
        if (this.bandwidthMgmtService == bandwidthMgmtService) {
            this.bandwidthMgmtService = null;
        }
    }

    protected void bindNetConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        this.netConfigRegistry = networkConfigRegistry;
    }

    protected void unbindNetConfigRegistry(NetworkConfigRegistry networkConfigRegistry) {
        if (this.netConfigRegistry == networkConfigRegistry) {
            this.netConfigRegistry = null;
        }
    }

    private class GlobalOptimizationTimer
    implements Runnable {
        @Override
        public void run() {
            PceManager.this.callForOptimization();
        }
    }

    private class InnerTunnelListener
    implements TunnelListener {
        private InnerTunnelListener() {
        }

        public void event(TunnelEvent event) {
            Tunnel tunnel = (Tunnel)event.subject();
            if (tunnel.type() != Tunnel.Type.MPLS) {
                return;
            }
            LspType lspType = LspType.valueOf(tunnel.annotations().value("lspSigType"));
            String tunnelBandwidth = tunnel.annotations().value("bandwidth");
            double bwConstraintValue = 0.0;
            if (tunnelBandwidth != null) {
                bwConstraintValue = Double.parseDouble(tunnelBandwidth);
            }
            switch ((TunnelEvent.Type)event.type()) {
                case TUNNEL_UPDATED: {
                    String costType;
                    if (PceManager.this.rsvpTunnelsWithLocalBw.contains(tunnel.tunnelId())) {
                        PceManager.this.releaseBandwidth((Tunnel)event.subject());
                        PceManager.this.rsvpTunnelsWithLocalBw.remove(tunnel.tunnelId());
                    }
                    if (tunnel.state() != Tunnel.State.UNSTABLE) break;
                    LinkedList<Constraint> constraints = new LinkedList<Constraint>();
                    String bandwidth = tunnel.annotations().value("bandwidth");
                    if (bandwidth != null) {
                        constraints.add((Constraint)new PceBandwidthConstraint(Bandwidth.bps((double)Double.parseDouble(bandwidth))));
                    }
                    if ((costType = tunnel.annotations().value("costType")) != null) {
                        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.valueOf(costType));
                        constraints.add(costConstraint);
                    }
                    constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(tunnel.annotations().value("lspSigType"))));
                    List links = tunnel.path().links();
                    PceManager.this.pceStore.addFailedPathInfo(new PcePathInfo(((Link)links.get(0)).src().deviceId(), ((Link)links.get(links.size() - 1)).dst().deviceId(), tunnel.tunnelName().value(), constraints, lspType, PceManager.this.pceStore.getTunnelNameExplicitPathInfoMap(tunnel.tunnelName().value()), tunnel.annotations().value(PceManager.LOAD_BALANCING_PATH_NAME) != null));
                    break;
                }
                case TUNNEL_REMOVED: {
                    if (lspType != LspType.WITH_SIGNALLING) {
                        PceManager.this.localLspIdFreeList.add((Object)Short.valueOf(tunnel.annotations().value("localLspId")));
                    }
                    if (bwConstraintValue == 0.0 || PceManager.this.mastershipService.getLocalRole(tunnel.path().src().deviceId()) != MastershipRole.MASTER || lspType == LspType.WITH_SIGNALLING) break;
                    PceManager.this.releaseBandwidth(tunnel);
                    break;
                }
            }
        }
    }

    private class InternalTopologyListener
    implements TopologyListener {
        private InternalTopologyListener() {
        }

        public void event(TopologyEvent event) {
            event.reasons().forEach(e -> {
                LinkEvent linkEvent;
                if (e instanceof LinkEvent && (linkEvent = (LinkEvent)e).type() == LinkEvent.Type.LINK_REMOVED) {
                    PceManager.this.tunnelService.queryTunnel(Tunnel.Type.MPLS).forEach(t -> {
                        if (t.path().links().contains(e.subject())) {
                            PceManager.this.checkForMasterAndUpdateTunnel(t.path().src().deviceId(), t);
                        }
                    });
                }
            });
        }
    }

    protected class TeConstraintBasedLinkWeight
    implements LinkWeight {
        private final List<Constraint> constraints;

        public TeConstraintBasedLinkWeight(List<Constraint> constraints) {
            this.constraints = constraints == null ? Collections.emptyList() : ImmutableList.copyOf(constraints);
        }

        public double weight(TopologyEdge edge) {
            if (!this.constraints.iterator().hasNext()) {
                return 1.0;
            }
            Iterator<Constraint> it = this.constraints.iterator();
            double cost = 1.0;
            while (it.hasNext() && cost > 0.0) {
                Constraint constraint = it.next();
                if (constraint instanceof CapabilityConstraint) {
                    cost = ((CapabilityConstraint)constraint).isValidLink(edge.link(), PceManager.this.deviceService, PceManager.this.netCfgService) ? 1.0 : -1.0;
                    continue;
                }
                if (constraint instanceof PceBandwidthConstraint) {
                    cost = ((PceBandwidthConstraint)constraint).isValidLink(edge.link(), PceManager.this.bandwidthMgmtService) ? 1.0 : -1.0;
                    continue;
                }
                if (constraint instanceof SharedBandwidthConstraint) {
                    cost = ((SharedBandwidthConstraint)constraint).isValidLink(edge.link(), PceManager.this.bandwidthMgmtService) ? 1.0 : -1.0;
                    continue;
                }
                if (constraint instanceof CostConstraint) {
                    cost = ((CostConstraint)constraint).isValidLink(edge.link(), PceManager.this.netCfgService);
                    continue;
                }
                cost = constraint.cost(edge.link(), null);
            }
            return cost;
        }
    }
}

