/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.cli;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.util.DataRateUnit;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.pce.pceservice.ExplicitPathInfo;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pceservice.constraint.PceBandwidthConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="pce-setup-path", description="Supports creating pce path.")
public class PceSetupPathCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final byte SUBTYPE_DEVICEID = 0;
    public static final byte SUBTYPE_LINK = 1;
    public static final byte SUBTYPE_INDEX = 1;
    public static final byte TYPE_INDEX = 0;
    public static final byte DEVICEID_INDEX = 2;
    public static final byte SOURCE_DEVICEID_INDEX = 2;
    public static final byte SOURCE_PORTNO_INDEX = 3;
    public static final byte DESTINATION_DEVICEID_INDEX = 4;
    public static final byte DESTINATION_PORTNO_INDEX = 5;
    @Argument(index=0, name="src", description="source device.", required=true, multiValued=false)
    String src = null;
    @Argument(index=1, name="dst", description="destination device.", required=true, multiValued=false)
    String dst = null;
    @Argument(index=2, name="type", description="LSP type: It includes PCE tunnel with signalling in network (0), PCE tunnel without signalling in network with segment routing (1), PCE tunnel without signalling in network (2).", required=true, multiValued=false)
    int type = 0;
    @Argument(index=3, name="name", description="symbolic-path-name.", required=true, multiValued=false)
    String name = null;
    @Option(name="-c", aliases={"--cost"}, description="The cost attribute IGP cost(1) or TE cost(2)", required=false, multiValued=false)
    int cost = 2;
    @Option(name="-b", aliases={"--bandwidth"}, description="The bandwidth attribute of path. Data rate unit is in BPS.", required=false, multiValued=false)
    double bandwidth = 0.0;
    @Option(name="-e", aliases={"--explicitPathObjects"}, description="List of strict and loose hopes explicitPathInfo format : Type/SubType/Value(DeviceId or Link info)\n If Value is Device : Type/SubType/deviceId\n If Value is Link : Type/SubType/SourceDeviceId/SourcePortNo/DestinationDeviceId/DestinationPortNoType 0 - strict, 1 - loose \nSubType 0 - deviceId, 1 - link \n", required=false, multiValued=true)
    String[] explicitPathInfoStrings;
    @Option(name="-l", aliases={"--loadBalancing"}, description="The load balancing option for user. ", required=false, multiValued=false)
    boolean loadBalancing = false;
    List<ExplicitPathInfo> explicitPathInfo = Lists.newLinkedList();

    protected void execute() {
        this.log.info("executing pce-setup-path");
        PceService service = (PceService)PceSetupPathCommand.get(PceService.class);
        TunnelService tunnelService = (TunnelService)PceSetupPathCommand.get(TunnelService.class);
        DeviceId srcDevice = DeviceId.deviceId((String)this.src);
        DeviceId dstDevice = DeviceId.deviceId((String)this.dst);
        LinkedList<Constraint> listConstrnt = new LinkedList<Constraint>();
        if (this.type < 0 || this.type > 2) {
            this.error("The LSP type value can be PCE tunnel with signalling in network (0), PCE tunnel without signalling in network with segment routing (1), PCE tunnel without signalling in network (2).", new Object[0]);
            return;
        }
        LspType lspType = LspType.values()[this.type];
        Collection existingTunnels = tunnelService.queryTunnel(Tunnel.Type.MPLS);
        for (Tunnel t : existingTunnels) {
            if (!t.tunnelName().toString().equals(this.name)) continue;
            this.error("Path creation failed, Tunnel name already exists", new Object[0]);
            return;
        }
        if (this.bandwidth != 0.0) {
            listConstrnt.add((Constraint)PceBandwidthConstraint.of(this.bandwidth, DataRateUnit.valueOf((String)"BPS")));
        }
        if (this.cost < 1 || this.cost > 2) {
            this.error("The cost attribute value either IGP cost(1) or TE cost(2).", new Object[0]);
            return;
        }
        CostConstraint.Type costType = CostConstraint.Type.values()[this.cost - 1];
        listConstrnt.add(CostConstraint.of(costType));
        if (this.explicitPathInfoStrings != null) {
            for (String str : this.explicitPathInfoStrings) {
                String[] splitted = str.split("/");
                DeviceId res = null;
                int explicitPathType = Integer.parseInt(splitted[0]);
                if (explicitPathType < 0 || explicitPathType > 1) {
                    this.error("Explicit path validation failed", new Object[0]);
                    return;
                }
                if (splitted[2] != null && Integer.parseInt(splitted[1]) == 0) {
                    res = DeviceId.deviceId((String)splitted[2]);
                } else if (Integer.parseInt(splitted[1]) == 1 && splitted[2] != null && splitted[3] != null && splitted[4] != null && splitted[5] != null) {
                    DeviceId deviceId = DeviceId.deviceId((String)splitted[2]);
                    PortNumber portNo = PortNumber.portNumber((String)splitted[3]);
                    ConnectPoint cpSrc = new ConnectPoint((ElementId)deviceId, portNo);
                    deviceId = DeviceId.deviceId((String)splitted[4]);
                    portNo = PortNumber.portNumber((String)splitted[5]);
                    ConnectPoint cpDst = new ConnectPoint((ElementId)deviceId, portNo);
                    res = DefaultLink.builder().providerId(ProviderId.NONE).src(cpSrc).dst(cpDst).type(Link.Type.DIRECT).state(Link.State.ACTIVE).build();
                } else {
                    this.error("Explicit path validation failed", new Object[0]);
                    return;
                }
                ExplicitPathInfo obj = new ExplicitPathInfo(ExplicitPathInfo.Type.values()[explicitPathType], (NetworkResource)res);
                this.explicitPathInfo.add(obj);
            }
        }
        if (this.loadBalancing) {
            if (!service.setupPath(srcDevice, dstDevice, this.name, listConstrnt, lspType, this.loadBalancing)) {
                this.error("Path creation failed.", new Object[0]);
            }
            return;
        }
        if (!service.setupPath(srcDevice, dstDevice, this.name, listConstrnt, lspType, this.explicitPathInfo)) {
            this.error("Path creation failed.", new Object[0]);
        }
    }
}

