/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.cli;

import java.util.List;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.pce.pceservice.ExplicitPathInfo;
import org.onosproject.pce.pceservice.api.PceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="pce-query-path", description="Supports querying PCE path.")
public class PceQueryPathCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String COST_TYPE = "costType";
    @Option(name="-i", aliases={"--id"}, description="path-id", required=false, multiValued=false)
    String id = null;

    /*
     * Enabled aggressive block sorting
     */
    protected void execute() {
        this.log.info("executing pce-query-path");
        PceService service = (PceService)PceQueryPathCommand.get(PceService.class);
        if (null == this.id) {
            Iterable<Tunnel> tunnels = service.queryAllPath();
            if (tunnels == null) {
                this.print("No path is found.", new Object[0]);
                return;
            }
            for (Tunnel tunnel : tunnels) {
                this.display(tunnel);
            }
            return;
        } else {
            Tunnel tunnel = service.queryPath(TunnelId.valueOf((String)this.id));
            if (tunnel == null) {
                this.print("Path doesnot exists.", new Object[0]);
                return;
            }
            this.display(tunnel);
        }
    }

    void display(Tunnel tunnel) {
        List<ExplicitPathInfo> explicitPathInfoList = ((PceService)AbstractShellCommand.get(PceService.class)).explicitPathInfoList(tunnel.tunnelName().value());
        this.print("\npath-id                  : %s \nsource                   : %s \ndestination              : %s \npath-type                : %s \nsymbolic-path-name       : %s \nconstraints:            \n   cost                  : %s \n   bandwidth             : %s", new Object[]{tunnel.tunnelId().id(), tunnel.path().src().deviceId().toString(), tunnel.path().dst().deviceId().toString(), tunnel.type().name(), tunnel.tunnelName(), tunnel.annotations().value(COST_TYPE), tunnel.annotations().value("bandwidth")});
        if (explicitPathInfoList != null) {
            for (ExplicitPathInfo e : explicitPathInfoList) {
                this.print("explicitPathObjects      : \n    type                 : %s \n    value                : %s ", new Object[]{String.valueOf(e.type().type()), e.value().toString()});
            }
        }
    }
}

