/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.cli;

import java.util.List;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.pce.pceservice.api.PceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="pce-query-load-balancing-path", description="Supports querying PCE path.")
public class PceQueryLoadBalancingPathCommand
extends AbstractShellCommand {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String COST_TYPE = "costType";
    @Argument(index=0, name="pathName", description="load balencing path name", required=true, multiValued=false)
    String name = null;

    protected void execute() {
        this.log.info("executing pce-query-load-balancing-path");
        PceService service = (PceService)PceQueryLoadBalancingPathCommand.get(PceService.class);
        if (this.name == null) {
            this.print("Path name is mandatory", new Object[0]);
            return;
        }
        List<TunnelId> tunnelIds = service.queryLoadBalancingPath(this.name);
        if (tunnelIds == null || tunnelIds.isEmpty()) {
            this.print("Release path failed", new Object[0]);
            return;
        }
        for (TunnelId id : tunnelIds) {
            Tunnel tunnel = service.queryPath(id);
            if (tunnel == null) {
                this.print("Path doesnot exists", new Object[0]);
                return;
            }
            this.display(tunnel);
        }
    }

    void display(Tunnel tunnel) {
        this.print("\npath-id                  : %s \nsource                   : %s \ndestination              : %s \npath-type                : %s \nsymbolic-path-name       : %s \nconstraints:            \n   cost                  : %s \n   bandwidth             : %s", new Object[]{tunnel.tunnelId().id(), tunnel.path().src().deviceId().toString(), tunnel.path().dst().deviceId().toString(), tunnel.type().name(), tunnel.tunnelName(), tunnel.annotations().value(COST_TYPE), tunnel.annotations().value("bandwidth")});
        this.print("Path                     : %s", new Object[]{tunnel.path().toString()});
    }
}

