/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pcep.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.pcep.controller.PcepClientController;
import org.onosproject.pcep.controller.PcepErrorDetail;
import org.onosproject.pcep.controller.PcepErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="onos", name="pcep", description="Pcep Session Info")
public class PcepSessionCommand
extends AbstractShellCommand {
    private static final Logger log = LoggerFactory.getLogger(PcepSessionCommand.class);
    private static final String SESSION = "session";
    private static final String EXCEPTION = "exception";
    private static final String ERROR = "error";
    private PcepClientController pcepClientController;
    private byte sessionId;
    private Set<String> pcepSessionKeySet;
    private Set<String> pcepSessionIdKeySet;
    private Integer sessionIdValue = 0;
    private String sessionStatus;
    private List pcepSessionExceptions = new ArrayList();
    private Set<String> pcepSessionFailurekeySet;
    private PcepErrorDetail pcepErrorDetail;
    private PcepErrorType pcepErrorType;
    private Map<Integer, String> sessionEstablishmentFailureMap = new TreeMap<Integer, String>();
    private Map<Integer, String> unknownObjectMap = new TreeMap<Integer, String>();
    private Map<Integer, String> notSupportedObjectMap = new TreeMap<Integer, String>();
    private Map<Integer, String> policyViolationMap = new TreeMap<Integer, String>();
    private Map<Integer, String> mandatoryObjectMissingMap = new TreeMap<Integer, String>();
    private Map<Integer, String> receptionOfInvalidObjectMap = new TreeMap<Integer, String>();
    private Map<Integer, String> invalidOperationMap = new TreeMap<Integer, String>();
    private Set<Integer> pcepErrorMsgKey;
    private Integer pcepErrorValue = 0;
    @Argument(index=0, name="name", description="session\nexception\nerror", required=true, multiValued=false)
    String name = null;
    @Argument(index=1, name="peer", description="peerIp", required=false, multiValued=false)
    String peer = null;

    protected void execute() {
        switch (this.name) {
            case "session": {
                this.displayPcepSession();
                break;
            }
            case "exception": {
                this.displayPcepSessionFailureReason();
                break;
            }
            case "error": {
                this.displayPcepErrorMsgs();
                break;
            }
            default: {
                System.out.print("Unknown Command");
            }
        }
    }

    private void displayPcepSession() {
        try {
            this.pcepClientController = (PcepClientController)PcepSessionCommand.get(PcepClientController.class);
            Map pcepSessionMap = this.pcepClientController.getPcepSessionMap();
            Map pcepSessionIdMap = this.pcepClientController.getPcepSessionIdMap();
            this.pcepSessionKeySet = pcepSessionMap.keySet();
            this.pcepSessionIdKeySet = pcepSessionIdMap.keySet();
            if (this.peer != null) {
                if (!this.pcepSessionKeySet.isEmpty()) {
                    if (this.pcepSessionKeySet.contains(this.peer)) {
                        for (String pcepSessionPeer : this.pcepSessionKeySet) {
                            if (!pcepSessionPeer.equals(this.peer)) continue;
                            for (String pcepSessionId : this.pcepSessionIdKeySet) {
                                if (!pcepSessionId.equals(this.peer)) continue;
                                this.sessionId = (Byte)pcepSessionIdMap.get(pcepSessionId);
                                this.sessionStatus = (String)pcepSessionMap.get(pcepSessionPeer);
                                if (this.sessionId < 0) {
                                    this.sessionIdValue = this.sessionId + 256;
                                    continue;
                                }
                                this.sessionIdValue = this.sessionId;
                            }
                            this.print("SessionIp = %s, Status = %s, sessionId = %s", new Object[]{pcepSessionPeer, this.sessionStatus, this.sessionIdValue});
                        }
                    } else {
                        System.out.print("Wrong Peer IP");
                    }
                }
            } else if (!this.pcepSessionKeySet.isEmpty()) {
                for (String pcepSessionPeer : this.pcepSessionKeySet) {
                    for (String pcepSessionId : this.pcepSessionIdKeySet) {
                        if (!pcepSessionId.equals(pcepSessionPeer)) continue;
                        this.sessionId = (Byte)pcepSessionIdMap.get(pcepSessionId);
                        this.sessionStatus = (String)pcepSessionMap.get(pcepSessionPeer);
                        if (this.sessionId < 0) {
                            this.sessionIdValue = this.sessionId + 256;
                            continue;
                        }
                        this.sessionIdValue = this.sessionId;
                    }
                    this.print("SessionIp = %s, Status = %s, sessionId = %s", new Object[]{pcepSessionPeer, this.sessionStatus, this.sessionIdValue});
                }
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying PCEP session information: {}", (Object)e.getMessage());
        }
    }

    private void displayPcepSessionFailureReason() {
        try {
            this.pcepClientController = (PcepClientController)PcepSessionCommand.get(PcepClientController.class);
            Map pcepSessionFailureReasonMap = this.pcepClientController.getPcepExceptions();
            this.pcepSessionFailurekeySet = pcepSessionFailureReasonMap.keySet();
            if (!this.pcepSessionFailurekeySet.isEmpty()) {
                if (this.peer != null) {
                    if (this.pcepSessionFailurekeySet.contains(this.peer)) {
                        for (String pcepSessionPeerId : this.pcepSessionFailurekeySet) {
                            if (!pcepSessionPeerId.equals(this.peer)) continue;
                            this.pcepSessionExceptions = (List)pcepSessionFailureReasonMap.get(pcepSessionPeerId);
                            this.print("PeerId = %s, FailureReason = %s", new Object[]{pcepSessionPeerId, this.pcepSessionExceptions});
                        }
                    } else {
                        System.out.print("Wrong Peer IP");
                    }
                } else {
                    this.pcepSessionFailurekeySet = pcepSessionFailureReasonMap.keySet();
                    if (!this.pcepSessionFailurekeySet.isEmpty()) {
                        for (String pcepSessionPeerId : this.pcepSessionFailurekeySet) {
                            this.pcepSessionExceptions = (List)pcepSessionFailureReasonMap.get(pcepSessionPeerId);
                            this.print("PeerId = %s, FailureReason = %s", new Object[]{pcepSessionPeerId, this.pcepSessionExceptions});
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying PCEP session failure reasons: {}", (Object)e.getMessage());
        }
    }

    private void displayPcepErrorMsgs() {
        try {
            this.pcepClientController = (PcepClientController)PcepSessionCommand.get(PcepClientController.class);
            Map pcepErrorMsgMap = this.pcepClientController.getPcepErrorMsg();
            this.pcepErrorMsgKey = pcepErrorMsgMap.keySet();
            if (!this.pcepErrorMsgKey.isEmpty()) {
                for (Integer errorType : this.pcepErrorMsgKey) {
                    this.pcepErrorValue = (Integer)pcepErrorMsgMap.get(errorType);
                    this.pcepErrorType = PcepErrorType.values()[errorType];
                    switch (this.pcepErrorType) {
                        case SESSIONESTABLISHMENTFAILURE: {
                            this.sessionEstablishmentFailureMap = this.pcepErrorDetail.sessionEstablishmentFailure();
                            Set<Integer> sessionFailureKeySet = this.sessionEstablishmentFailureMap.keySet();
                            for (Integer n : sessionFailureKeySet) {
                                if (!n.equals(this.pcepErrorValue)) continue;
                                System.out.print(this.sessionEstablishmentFailureMap.get(n));
                            }
                        }
                        case CAPABALITYNOTSUPPORTED: {
                            System.out.print("Capability not supported");
                        }
                        case UNKNOWNOBJECT: {
                            this.unknownObjectMap = this.pcepErrorDetail.unknownObject();
                            Set<Integer> unknownObjectKeySet = this.unknownObjectMap.keySet();
                            for (Object unknownObjectKey : unknownObjectKeySet) {
                                if (!((Integer)unknownObjectKey).equals(this.pcepErrorValue)) continue;
                                System.out.print(this.unknownObjectMap.get(unknownObjectKey));
                            }
                        }
                        case NOTSUPPORTEDOBJECT: {
                            Object unknownObjectKey;
                            this.notSupportedObjectMap = this.pcepErrorDetail.notSupportedObject();
                            Set<Integer> set = this.notSupportedObjectMap.keySet();
                            unknownObjectKey = set.iterator();
                            while (unknownObjectKey.hasNext()) {
                                Integer n = unknownObjectKey.next();
                                if (!n.equals(this.pcepErrorValue)) continue;
                                System.out.print(this.notSupportedObjectMap.get(n));
                            }
                        }
                        case POLICYVIOLATION: {
                            this.policyViolationMap = this.pcepErrorDetail.policyViolation();
                            Set<Integer> policyViolationKeySet = this.policyViolationMap.keySet();
                            for (Object policyViolationKey : policyViolationKeySet) {
                                if (!((Integer)policyViolationKey).equals(this.pcepErrorValue)) continue;
                                System.out.print(this.policyViolationMap.get(policyViolationKey));
                            }
                        }
                        case MANDATORYOBJECTMISSING: {
                            Object policyViolationKey;
                            this.mandatoryObjectMissingMap = this.pcepErrorDetail.mandatoryObjectMissing();
                            Set<Integer> set = this.mandatoryObjectMissingMap.keySet();
                            policyViolationKey = set.iterator();
                            while (policyViolationKey.hasNext()) {
                                Integer n = policyViolationKey.next();
                                if (!n.equals(this.pcepErrorValue)) continue;
                                System.out.print(this.mandatoryObjectMissingMap.get(n));
                            }
                        }
                        case SYNCHRONIZEDPATHCOMPUTATIONREQUESTMISSING: {
                            System.out.print("Synchronized path computation request missing");
                        }
                        case UNKNOWNREQUESTREFERENCE: {
                            System.out.print("Unknown request reference");
                        }
                        case ESTABLISHINGSECONDPCEPSESSION: {
                            System.out.print("Attempt to establish a second PCEP session");
                        }
                        case RECEPTIONOFINVALIDOBJECT: {
                            this.receptionOfInvalidObjectMap = this.pcepErrorDetail.receptionOfInvalidObject();
                            Set<Integer> receptionOfInvalidObjectKeySet = this.receptionOfInvalidObjectMap.keySet();
                            for (Integer receptionOfInvalidObjectKey : receptionOfInvalidObjectKeySet) {
                                if (!receptionOfInvalidObjectKey.equals(this.pcepErrorValue)) continue;
                                System.out.print(this.receptionOfInvalidObjectMap.get(receptionOfInvalidObjectKey));
                            }
                        }
                        case INVALIDOPERATION: {
                            this.invalidOperationMap = this.pcepErrorDetail.invalidOperation();
                            Set<Integer> set = this.invalidOperationMap.keySet();
                            for (Integer invalidOperationKey : set) {
                                if (!invalidOperationKey.equals(this.pcepErrorValue)) continue;
                                System.out.print(this.invalidOperationMap.get(invalidOperationKey));
                            }
                        }
                        case VIRTUALNETWORKTLVMISSING: {
                            System.out.print("VIRTUAL-NETWORK TLV missing");
                        }
                    }
                    System.out.print("Unknown error message");
                }
            }
        }
        catch (Exception e) {
            log.debug("Error occurred while displaying PCEP error messages received: {}", (Object)e.getMessage());
        }
    }
}

