/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.OchSignal;

@Beta
public abstract class OchSignalCodec {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static OchSignal decode(ObjectNode obj) {
        String s = obj.get("channelSpacing").textValue();
        Preconditions.checkArgument((s != null ? 1 : 0) != 0, (Object)"ill-formed channelSpacing");
        ChannelSpacing channelSpacing = Enum.valueOf(ChannelSpacing.class, s);
        s = obj.get("gridType").textValue();
        Preconditions.checkArgument((s != null ? 1 : 0) != 0, (Object)"ill-formed gridType");
        GridType gridType = Enum.valueOf(GridType.class, s);
        JsonNode node = obj.get("spacingMultiplier");
        Preconditions.checkArgument((boolean)node.canConvertToInt(), (Object)"ill-formed spacingMultiplier");
        int spacingMultiplier = node.asInt();
        node = obj.get("slotGranularity");
        Preconditions.checkArgument((boolean)node.canConvertToInt(), (Object)"ill-formed slotGranularity");
        int slotGranularity = node.asInt();
        return new OchSignal(gridType, channelSpacing, spacingMultiplier, slotGranularity);
    }

    public static ObjectNode encode(OchSignal j) {
        ObjectNode obj = MAPPER.createObjectNode();
        obj.put("channelSpacing", j.channelSpacing().toString());
        obj.put("gridType", j.gridType().toString());
        obj.put("slotGranularity", j.slotGranularity());
        obj.put("spacingMultiplier", j.spacingMultiplier());
        return obj;
    }
}

