/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.optical.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.Annotations;
import org.onosproject.net.OtuSignalType;
import org.onosproject.net.Port;
import org.onosproject.net.optical.OtuPort;
import org.onosproject.net.optical.device.OtuPortHelper;
import org.onosproject.net.utils.ForwardingPort;

@Beta
public class DefaultOtuPort
extends ForwardingPort
implements OtuPort {
    private final OtuSignalType signalType;

    public DefaultOtuPort(Port delegate, OtuSignalType signalType) {
        super(delegate);
        this.signalType = (OtuSignalType)Preconditions.checkNotNull((Object)signalType);
    }

    public Port.Type type() {
        return Port.Type.OTU;
    }

    @Override
    public Annotations unhandledAnnotations() {
        return OtuPortHelper.stripHandledAnnotations(super.annotations());
    }

    @Override
    public OtuSignalType signalType() {
        return this.signalType;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.signalType());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            DefaultOtuPort that = (DefaultOtuPort)obj;
            return super.toEqualsBuilder((Port)that).append((Object)this.signalType(), (Object)that.signalType()).isEquals();
        }
        return false;
    }

    public String toString() {
        return super.toStringHelper().add("signalType", (Object)this.signalType()).add("annotations", (Object)this.unhandledAnnotations()).toString();
    }
}

