/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.codec.CodecContext;
import org.onosproject.cpman.ControlLoadSnapshot;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.ControlResource;
import org.onosproject.net.DeviceId;
import org.onosproject.rest.AbstractWebResource;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="controlmetrics")
public class ControlMetricsWebResource
extends AbstractWebResource {
    private final ControlPlaneMonitorService monitorService = (ControlPlaneMonitorService)this.get(ControlPlaneMonitorService.class);
    private final ClusterService clusterService = (ClusterService)this.get(ClusterService.class);
    private final NodeId localNodeId = this.clusterService.getLocalNode().id();
    private final ObjectNode root = this.mapper().createObjectNode();

    @GET
    @Path(value="messages")
    @Produces(value={"application/json"})
    public Response controlMessageMetrics() {
        ArrayNode deviceNodes = this.root.putArray("devices");
        this.monitorService.availableResourcesSync(this.localNodeId, ControlResource.Type.CONTROL_MESSAGE).forEach(name -> {
            ObjectNode deviceNode = this.mapper().createObjectNode();
            ObjectNode valueNode = this.mapper().createObjectNode();
            this.metricsStats(this.monitorService, this.localNodeId, ControlResource.CONTROL_MESSAGE_METRICS, DeviceId.deviceId((String)name), valueNode);
            deviceNode.put("name", name);
            deviceNode.set("value", (JsonNode)valueNode);
            deviceNodes.add((JsonNode)deviceNode);
        });
        return ControlMetricsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="messages/{deviceId}")
    public Response controlMessageMetrics(@PathParam(value="deviceId") String deviceId) {
        this.metricsStats(this.monitorService, this.localNodeId, ControlResource.CONTROL_MESSAGE_METRICS, DeviceId.deviceId((String)deviceId), this.root);
        return ControlMetricsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Path(value="cpu_metrics")
    @Produces(value={"application/json"})
    public Response cpuMetrics() {
        this.metricsStats(this.monitorService, this.localNodeId, ControlResource.CPU_METRICS, this.root);
        return ControlMetricsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Path(value="memory_metrics")
    @Produces(value={"application/json"})
    public Response memoryMetrics() {
        this.metricsStats(this.monitorService, this.localNodeId, ControlResource.MEMORY_METRICS, this.root);
        return ControlMetricsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Path(value="disk_metrics")
    @Produces(value={"application/json"})
    public Response diskMetrics() {
        ArrayNode diskNodes = this.root.putArray("disks");
        this.monitorService.availableResourcesSync(this.localNodeId, ControlResource.Type.DISK).forEach(name -> {
            ObjectNode diskNode = this.mapper().createObjectNode();
            ObjectNode valueNode = this.mapper().createObjectNode();
            this.metricsStats(this.monitorService, this.localNodeId, ControlResource.DISK_METRICS, name, valueNode);
            diskNode.put("name", name);
            diskNode.set("value", (JsonNode)valueNode);
            diskNodes.add((JsonNode)diskNode);
        });
        return ControlMetricsWebResource.ok((Object)this.root).build();
    }

    @GET
    @Path(value="network_metrics")
    @Produces(value={"application/json"})
    public Response networkMetrics() {
        ArrayNode networkNodes = this.root.putArray("networks");
        this.monitorService.availableResourcesSync(this.localNodeId, ControlResource.Type.NETWORK).forEach(name -> {
            ObjectNode networkNode = this.mapper().createObjectNode();
            ObjectNode valueNode = this.mapper().createObjectNode();
            this.metricsStats(this.monitorService, this.localNodeId, ControlResource.NETWORK_METRICS, name, valueNode);
            networkNode.put("name", name);
            networkNode.set("value", (JsonNode)valueNode);
            networkNodes.add((JsonNode)networkNode);
        });
        return ControlMetricsWebResource.ok((Object)this.root).build();
    }

    private ArrayNode metricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet, DeviceId did, ObjectNode node) {
        return this.metricsStats(service, nodeId, typeSet, null, did, node);
    }

    private ArrayNode metricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet, ObjectNode node) {
        return this.metricsStats(service, nodeId, typeSet, null, null, node);
    }

    private ArrayNode metricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet, String resourceName, ObjectNode node) {
        return this.metricsStats(service, nodeId, typeSet, resourceName, null, node);
    }

    private ArrayNode metricsStats(ControlPlaneMonitorService service, NodeId nodeId, Set<ControlMetricType> typeSet, String name, DeviceId did, ObjectNode node) {
        ArrayNode metricsNode = node.putArray("metrics");
        if (name == null && did == null) {
            typeSet.forEach(type -> {
                ControlLoadSnapshot cls = service.getLoadSync(nodeId, type, Optional.empty());
                this.processRest(cls, type, metricsNode);
            });
        } else if (name == null) {
            typeSet.forEach(type -> {
                ControlLoadSnapshot cls = service.getLoadSync(nodeId, type, Optional.of(did));
                this.processRest(cls, type, metricsNode);
            });
        } else if (did == null) {
            typeSet.forEach(type -> {
                ControlLoadSnapshot cls = service.getLoadSync(nodeId, type, name);
                this.processRest(cls, type, metricsNode);
            });
        }
        return metricsNode;
    }

    private String toCamelCase(String value, boolean startWithLowerCase) {
        int i;
        Object[] strings = StringUtils.split((String)value.toLowerCase(), (String)"_");
        int n = i = startWithLowerCase ? 1 : 0;
        while (i < strings.length) {
            strings[i] = StringUtils.capitalize((String)strings[i]);
            ++i;
        }
        return StringUtils.join((Object[])strings);
    }

    private void processRest(ControlLoadSnapshot cls, ControlMetricType type, ArrayNode metricsNode) {
        ObjectNode metricNode = this.mapper().createObjectNode();
        if (cls != null) {
            metricNode.set(this.toCamelCase(type.toString(), true), (JsonNode)this.codec(ControlLoadSnapshot.class).encode((Object)cls, (CodecContext)this));
            metricsNode.add((JsonNode)metricNode);
        }
    }
}

