/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.rest;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.codec.CodecService;
import org.onosproject.codec.JsonCodec;
import org.onosproject.cpman.ControlLoadSnapshot;
import org.onosproject.cpman.codec.ControlLoadSnapshotCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class CPManCodecRegistrator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CodecService codecService;

    @Activate
    public void activate() {
        this.codecService.registerCodec(ControlLoadSnapshot.class, (JsonCodec)new ControlLoadSnapshotCodec());
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.codecService.unregisterCodec(ControlLoadSnapshot.class);
        this.log.info("Stopped");
    }

    protected void bindCodecService(CodecService codecService) {
        this.codecService = codecService;
    }

    protected void unbindCodecService(CodecService codecService) {
        if (this.codecService == codecService) {
            this.codecService = null;
        }
    }
}

