/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.onosproject.cpman.ControlLoad;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.MetricsDatabase;

public class DefaultControlLoad
implements ControlLoad {
    private final MetricsDatabase mdb;
    private final ControlMetricType type;

    public DefaultControlLoad(MetricsDatabase mdb, ControlMetricType type) {
        this.mdb = mdb;
        this.type = type;
    }

    public long average(int duration, TimeUnit unit) {
        return (long)Arrays.stream(this.recent(duration, unit)).average().getAsDouble();
    }

    public long average() {
        return (long)Arrays.stream(this.all()).average().getAsDouble();
    }

    public long rate() {
        return 0L;
    }

    public long latest() {
        return (long)this.mdb.recentMetric(this.type.toString());
    }

    public boolean isValid() {
        return true;
    }

    public long time() {
        return this.mdb.lastUpdate(this.type.toString());
    }

    public long[] recent(int duration, TimeUnit unit) {
        return this.doubleToLong(this.mdb.recentMetrics(this.type.toString(), duration, unit));
    }

    public long[] all() {
        return this.doubleToLong(this.mdb.metrics(this.type.toString()));
    }

    private double nanToZero(double d) {
        return Double.isNaN(d) ? 0.0 : d;
    }

    private long[] doubleToLong(double[] array) {
        long[] longArray = new long[array.length];
        IntStream.range(0, array.length).forEach(i -> {
            longArray[i] = (long)this.nanToZero(array[i]);
        });
        return longArray;
    }
}

