/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.cluster.ClusterService;
import org.onosproject.cluster.NodeId;
import org.onosproject.cpman.ControlLoad;
import org.onosproject.cpman.ControlLoadSnapshot;
import org.onosproject.cpman.ControlMetric;
import org.onosproject.cpman.ControlMetricType;
import org.onosproject.cpman.ControlMetricsRequest;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.ControlResource;
import org.onosproject.cpman.ControlResourceRequest;
import org.onosproject.cpman.MetricsDatabase;
import org.onosproject.cpman.impl.DefaultControlLoad;
import org.onosproject.cpman.impl.DefaultMetricsDatabase;
import org.onosproject.net.DeviceId;
import org.onosproject.store.cluster.messaging.ClusterCommunicationService;
import org.onosproject.store.cluster.messaging.MessageSubject;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ControlPlaneMonitor
implements ControlPlaneMonitorService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private MetricsDatabase cpuMetrics;
    private MetricsDatabase memoryMetrics;
    private Map<DeviceId, MetricsDatabase> controlMessageMap;
    private Map<String, MetricsDatabase> diskMetricsMap;
    private Map<String, MetricsDatabase> networkMetricsMap;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterService clusterService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ClusterCommunicationService communicationService;
    private static final String DEFAULT_RESOURCE = "default";
    private static final Set RESOURCE_TYPE_SET = ImmutableSet.of((Object)ControlResource.Type.CONTROL_MESSAGE, (Object)ControlResource.Type.DISK, (Object)ControlResource.Type.NETWORK);
    private static final MessageSubject CONTROL_STATS = new MessageSubject("control-plane-stats");
    private static final MessageSubject CONTROL_RESOURCE = new MessageSubject("control-plane-resources");
    private Map<ControlMetricType, Double> cpuBuf;
    private Map<ControlMetricType, Double> memoryBuf;
    private Map<String, Map<ControlMetricType, Double>> diskBuf;
    private Map<String, Map<ControlMetricType, Double>> networkBuf;
    private Map<DeviceId, Map<ControlMetricType, Double>> ctrlMsgBuf;
    private Map<ControlResource.Type, Set<String>> availableResourceMap;
    private Set<DeviceId> availableDeviceIdSet;
    private static final String METRIC_TYPE_NULL = "Control metric type cannot be null";
    private static final String RESOURCE_TYPE_NULL = "Control resource type cannot be null";
    private static final Serializer SERIALIZER = Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{ControlMetricsRequest.class}).register(new Class[]{ControlResourceRequest.class}).register(new Class[]{ControlLoadSnapshot.class}).register(new Class[]{ControlMetricType.class}).register(new Class[]{ControlResource.Type.class}).register(new Class[]{TimeUnit.class}).nextId(500).build());

    @Activate
    public void activate() {
        this.cpuMetrics = this.genMDbBuilder(DEFAULT_RESOURCE, ControlResource.Type.CPU, ControlResource.CPU_METRICS);
        this.memoryMetrics = this.genMDbBuilder(DEFAULT_RESOURCE, ControlResource.Type.MEMORY, ControlResource.MEMORY_METRICS);
        this.controlMessageMap = Maps.newConcurrentMap();
        this.diskMetricsMap = Maps.newConcurrentMap();
        this.networkMetricsMap = Maps.newConcurrentMap();
        this.cpuBuf = Maps.newConcurrentMap();
        this.memoryBuf = Maps.newConcurrentMap();
        this.diskBuf = Maps.newConcurrentMap();
        this.networkBuf = Maps.newConcurrentMap();
        this.ctrlMsgBuf = Maps.newConcurrentMap();
        this.availableResourceMap = Maps.newConcurrentMap();
        this.availableDeviceIdSet = Sets.newConcurrentHashSet();
        this.communicationService.addSubscriber(CONTROL_STATS, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), arg_0 -> this.handleMetricsRequest(arg_0), arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
        this.communicationService.addSubscriber(CONTROL_RESOURCE, arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), arg_0 -> this.handleResourceRequest(arg_0), arg_0 -> ((Serializer)SERIALIZER).encode(arg_0));
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.cpuBuf.clear();
        this.memoryBuf.clear();
        this.diskBuf.clear();
        this.networkBuf.clear();
        this.ctrlMsgBuf.clear();
        this.communicationService.removeSubscriber(CONTROL_STATS);
        this.communicationService.removeSubscriber(CONTROL_RESOURCE);
        this.log.info("Stopped");
    }

    public void updateMetric(ControlMetric cm, int updateIntervalInMinutes, Optional<DeviceId> deviceId) {
        if (deviceId.isPresent()) {
            this.ctrlMsgBuf.putIfAbsent(deviceId.get(), Maps.newConcurrentMap());
            if (ControlResource.CONTROL_MESSAGE_METRICS.contains(cm.metricType())) {
                if (!this.availableDeviceIdSet.contains(deviceId.get())) {
                    this.availableDeviceIdSet.add(deviceId.get());
                }
                ((Map)this.ctrlMsgBuf.get(deviceId.get())).putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
                if (((Map)this.ctrlMsgBuf.get(deviceId.get())).keySet().containsAll(ControlResource.CONTROL_MESSAGE_METRICS)) {
                    this.updateControlMessages((Map)this.ctrlMsgBuf.get(deviceId.get()), deviceId.get());
                    this.ctrlMsgBuf.clear();
                }
            }
        } else {
            if (ControlResource.CPU_METRICS.contains(cm.metricType())) {
                this.cpuBuf.putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
                if (this.cpuBuf.keySet().containsAll(ControlResource.CPU_METRICS)) {
                    this.cpuMetrics.updateMetrics(this.convertMap(this.cpuBuf));
                    this.cpuBuf.clear();
                }
            }
            if (ControlResource.MEMORY_METRICS.contains(cm.metricType())) {
                this.memoryBuf.putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
                if (this.memoryBuf.keySet().containsAll(ControlResource.MEMORY_METRICS)) {
                    this.memoryMetrics.updateMetrics(this.convertMap(this.memoryBuf));
                    this.memoryBuf.clear();
                }
            }
        }
    }

    public void updateMetric(ControlMetric cm, int updateIntervalInMinutes, String resourceName) {
        if (ControlResource.DISK_METRICS.contains(cm.metricType())) {
            this.diskBuf.putIfAbsent(resourceName, Maps.newConcurrentMap());
            this.availableResourceMap.putIfAbsent(ControlResource.Type.DISK, Sets.newHashSet());
            this.availableResourceMap.computeIfPresent(ControlResource.Type.DISK, (k, v) -> {
                v.add(resourceName);
                return v;
            });
            ((Map)this.diskBuf.get(resourceName)).putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
            if (((Map)this.diskBuf.get(resourceName)).keySet().containsAll(ControlResource.DISK_METRICS)) {
                this.updateDiskMetrics((Map)this.diskBuf.get(resourceName), resourceName);
                this.diskBuf.clear();
            }
        }
        if (ControlResource.NETWORK_METRICS.contains(cm.metricType())) {
            this.networkBuf.putIfAbsent(resourceName, Maps.newConcurrentMap());
            this.availableResourceMap.putIfAbsent(ControlResource.Type.NETWORK, Sets.newHashSet());
            this.availableResourceMap.computeIfPresent(ControlResource.Type.NETWORK, (k, v) -> {
                v.add(resourceName);
                return v;
            });
            ((Map)this.networkBuf.get(resourceName)).putIfAbsent(cm.metricType(), Double.valueOf(cm.metricValue().getLoad()));
            if (((Map)this.networkBuf.get(resourceName)).keySet().containsAll(ControlResource.NETWORK_METRICS)) {
                this.updateNetworkMetrics((Map)this.networkBuf.get(resourceName), resourceName);
                this.networkBuf.clear();
            }
        }
    }

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId nodeId, ControlMetricType type, Optional<DeviceId> deviceId) {
        if (this.clusterService.getLocalNode().id().equals((Object)nodeId)) {
            return CompletableFuture.completedFuture(this.snapshot(this.getLocalLoad(type, deviceId)));
        }
        return this.communicationService.sendAndReceive((Object)this.createMetricsRequest(type, deviceId), CONTROL_STATS, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), nodeId);
    }

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId nodeId, ControlMetricType type, String resourceName) {
        if (this.clusterService.getLocalNode().id().equals((Object)nodeId)) {
            return CompletableFuture.completedFuture(this.snapshot(this.getLocalLoad(type, resourceName)));
        }
        return this.communicationService.sendAndReceive((Object)this.createMetricsRequest(type, resourceName), CONTROL_STATS, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), nodeId);
    }

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId nodeId, ControlMetricType type, int duration, TimeUnit unit, Optional<DeviceId> deviceId) {
        if (this.clusterService.getLocalNode().id().equals((Object)nodeId)) {
            return CompletableFuture.completedFuture(this.snapshot(this.getLocalLoad(type, deviceId), duration, unit));
        }
        return this.communicationService.sendAndReceive((Object)this.createMetricsRequest(type, duration, unit, deviceId), CONTROL_STATS, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), nodeId);
    }

    public CompletableFuture<ControlLoadSnapshot> getLoad(NodeId nodeId, ControlMetricType type, int duration, TimeUnit unit, String resourceName) {
        if (this.clusterService.getLocalNode().id().equals((Object)nodeId)) {
            return CompletableFuture.completedFuture(this.snapshot(this.getLocalLoad(type, resourceName), duration, unit));
        }
        return this.communicationService.sendAndReceive((Object)this.createMetricsRequest(type, duration, unit, resourceName), CONTROL_STATS, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), nodeId);
    }

    public CompletableFuture<Set<String>> availableResources(NodeId nodeId, ControlResource.Type resourceType) {
        if (this.clusterService.getLocalNode().id().equals((Object)nodeId)) {
            Set resources = this.getLocalAvailableResources(resourceType);
            return CompletableFuture.completedFuture(resources);
        }
        return this.communicationService.sendAndReceive((Object)this.createResourceRequest(resourceType), CONTROL_RESOURCE, arg_0 -> ((Serializer)SERIALIZER).encode(arg_0), arg_0 -> ((Serializer)SERIALIZER).decode(arg_0), nodeId);
    }

    private MetricsDatabase genMDbBuilder(String resourceName, ControlResource.Type resourceType, Set<ControlMetricType> metricTypes) {
        DefaultMetricsDatabase.Builder builder = new DefaultMetricsDatabase.Builder();
        builder.withMetricName(resourceType.toString());
        builder.withResourceName(resourceName);
        metricTypes.forEach(arg_0 -> ControlPlaneMonitor.lambda$genMDbBuilder$2((MetricsDatabase.Builder)builder, arg_0));
        return builder.build();
    }

    private void updateNetworkMetrics(Map<ControlMetricType, Double> metricMap, String resourceName) {
        if (!this.networkMetricsMap.containsKey(resourceName)) {
            this.networkMetricsMap.put(resourceName, this.genMDbBuilder(resourceName, ControlResource.Type.NETWORK, ControlResource.NETWORK_METRICS));
        }
        ((MetricsDatabase)this.networkMetricsMap.get(resourceName)).updateMetrics(this.convertMap(metricMap));
    }

    private void updateDiskMetrics(Map<ControlMetricType, Double> metricMap, String resourceName) {
        if (!this.diskMetricsMap.containsKey(resourceName)) {
            this.diskMetricsMap.put(resourceName, this.genMDbBuilder(resourceName, ControlResource.Type.DISK, ControlResource.DISK_METRICS));
        }
        ((MetricsDatabase)this.diskMetricsMap.get(resourceName)).updateMetrics(this.convertMap(metricMap));
    }

    private void updateControlMessages(Map<ControlMetricType, Double> metricMap, DeviceId deviceId) {
        if (!this.controlMessageMap.containsKey(deviceId)) {
            this.controlMessageMap.put(deviceId, this.genMDbBuilder(deviceId.toString(), ControlResource.Type.CONTROL_MESSAGE, ControlResource.CONTROL_MESSAGE_METRICS));
        }
        ((MetricsDatabase)this.controlMessageMap.get(deviceId)).updateMetrics(this.convertMap(metricMap));
    }

    private Map<String, Double> convertMap(Map<ControlMetricType, Double> metricMap) {
        if (metricMap == null) {
            return ImmutableMap.of();
        }
        ConcurrentMap newMap = Maps.newConcurrentMap();
        metricMap.forEach((k, v) -> newMap.putIfAbsent(k.toString(), v));
        return newMap;
    }

    private CompletableFuture<ControlLoadSnapshot> handleMetricsRequest(ControlMetricsRequest request) {
        Preconditions.checkArgument((request.getType() != null ? 1 : 0) != 0, (Object)METRIC_TYPE_NULL);
        ControlLoad load = request.getResourceName() != null && request.getUnit() != null ? this.getLocalLoad(request.getType(), request.getResourceName()) : this.getLocalLoad(request.getType(), request.getDeviceId());
        long average = request.getUnit() != null ? load.average(request.getDuration(), request.getUnit()) : load.average();
        ControlLoadSnapshot resp = new ControlLoadSnapshot(load.latest(), average, load.time());
        return CompletableFuture.completedFuture(resp);
    }

    private CompletableFuture<Set<String>> handleResourceRequest(ControlResourceRequest request) {
        Preconditions.checkArgument((request.getType() != null ? 1 : 0) != 0, (Object)RESOURCE_TYPE_NULL);
        Set resources = this.getLocalAvailableResources(request.getType());
        return CompletableFuture.completedFuture(resources);
    }

    private ControlMetricsRequest createMetricsRequest(ControlMetricType type, Optional<DeviceId> deviceId) {
        return new ControlMetricsRequest(type, deviceId);
    }

    private ControlMetricsRequest createMetricsRequest(ControlMetricType type, int duration, TimeUnit unit, Optional<DeviceId> deviceId) {
        return new ControlMetricsRequest(type, duration, unit, deviceId);
    }

    private ControlMetricsRequest createMetricsRequest(ControlMetricType type, String resourceName) {
        return new ControlMetricsRequest(type, resourceName);
    }

    private ControlMetricsRequest createMetricsRequest(ControlMetricType type, int duration, TimeUnit unit, String resourceName) {
        return new ControlMetricsRequest(type, duration, unit, resourceName);
    }

    private ControlResourceRequest createResourceRequest(ControlResource.Type type) {
        return new ControlResourceRequest(type);
    }

    private ControlLoadSnapshot snapshot(ControlLoad cl) {
        if (cl != null) {
            return new ControlLoadSnapshot(cl.latest(), cl.average(), cl.time());
        }
        return null;
    }

    private ControlLoadSnapshot snapshot(ControlLoad cl, int duration, TimeUnit unit) {
        if (cl != null) {
            return new ControlLoadSnapshot(cl.latest(), cl.average(duration, unit), cl.time(), cl.recent(duration, unit));
        }
        return null;
    }

    private ControlLoad getLocalLoad(ControlMetricType type, Optional<DeviceId> deviceId) {
        if (deviceId.isPresent()) {
            if (ControlResource.CONTROL_MESSAGE_METRICS.contains(type) && this.availableDeviceIdSet.contains(deviceId.get())) {
                return new DefaultControlLoad((MetricsDatabase)this.controlMessageMap.get(deviceId.get()), type);
            }
        } else {
            if (ControlResource.CPU_METRICS.contains(type)) {
                return new DefaultControlLoad(this.cpuMetrics, type);
            }
            if (ControlResource.MEMORY_METRICS.contains(type)) {
                return new DefaultControlLoad(this.memoryMetrics, type);
            }
        }
        return null;
    }

    private ControlLoad getLocalLoad(ControlMetricType type, String resourceName) {
        NodeId localNodeId = this.clusterService.getLocalNode().id();
        if (ControlResource.DISK_METRICS.contains(type) && this.availableResourcesSync(localNodeId, ControlResource.Type.DISK).contains(resourceName)) {
            return new DefaultControlLoad((MetricsDatabase)this.diskMetricsMap.get(resourceName), type);
        }
        if (ControlResource.NETWORK_METRICS.contains(type) && this.availableResourcesSync(localNodeId, ControlResource.Type.NETWORK).contains(resourceName)) {
            return new DefaultControlLoad((MetricsDatabase)this.networkMetricsMap.get(resourceName), type);
        }
        return null;
    }

    private Set<String> getLocalAvailableResources(ControlResource.Type resourceType) {
        Object resources = ImmutableSet.of();
        if (RESOURCE_TYPE_SET.contains(resourceType)) {
            Set res;
            resources = ControlResource.Type.CONTROL_MESSAGE.equals((Object)resourceType) ? ImmutableSet.copyOf((Collection)this.availableDeviceIdSet.stream().map(DeviceId::toString).collect(Collectors.toSet())) : ((res = (Set)this.availableResourceMap.get(resourceType)) == null ? ImmutableSet.of() : res);
        }
        return resources;
    }

    private static /* synthetic */ void lambda$genMDbBuilder$2(MetricsDatabase.Builder builder, ControlMetricType type) {
        builder.addMetricType(type.toString());
    }

    protected void bindClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    protected void unbindClusterService(ClusterService clusterService) {
        if (this.clusterService == clusterService) {
            this.clusterService = null;
        }
    }

    protected void bindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        this.communicationService = clusterCommunicationService;
    }

    protected void unbindCommunicationService(ClusterCommunicationService clusterCommunicationService) {
        if (this.communicationService == clusterCommunicationService) {
            this.communicationService = null;
        }
    }
}

