/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cpman.cli;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.onosproject.cli.AbstractCompleter;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.cluster.NodeId;
import org.onosproject.cpman.ControlPlaneMonitorService;
import org.onosproject.cpman.ControlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceNameCompleter
extends AbstractCompleter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String NETWORK = "network";
    private static final String DISK = "disk";
    private static final String CONTROL_MESSAGE = "control_message";
    private final Set<String> resourceTypes = ImmutableSet.of((Object)"network", (Object)"disk", (Object)"control_message");
    private static final String INVALID_MSG = "Invalid type name";

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        ArgumentCompleter.ArgumentList list = this.getArgumentList();
        String nodeId = list.getArguments()[1];
        String type = list.getArguments()[2];
        if (this.resourceTypes.contains(type)) {
            ControlPlaneMonitorService monitorService = (ControlPlaneMonitorService)AbstractShellCommand.get(ControlPlaneMonitorService.class);
            Set set = Sets.newHashSet();
            switch (type) {
                case "network": {
                    set = monitorService.availableResourcesSync(NodeId.nodeId((String)nodeId), ControlResource.Type.NETWORK);
                    break;
                }
                case "disk": {
                    set = monitorService.availableResourcesSync(NodeId.nodeId((String)nodeId), ControlResource.Type.DISK);
                    break;
                }
                case "control_message": {
                    set = monitorService.availableResourcesSync(NodeId.nodeId((String)nodeId), ControlResource.Type.CONTROL_MESSAGE);
                    break;
                }
                default: {
                    this.log.warn(INVALID_MSG);
                }
            }
            SortedSet strings = delegate.getStrings();
            if (!set.isEmpty()) {
                set.forEach(strings::add);
            }
        }
        return delegate.complete(buffer, cursor, candidates);
    }
}

