/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.PacketUtils;
import org.onosproject.routing.fpm.protocol.RouteAttribute;
import org.onosproject.routing.fpm.protocol.RtProtocol;

public final class RtNetlink {
    private static final int RT_NETLINK_LENGTH = 12;
    private static final int MASK = 255;
    private final short addressFamily;
    private final int dstLength;
    private final int srcLength;
    private final short tos;
    private final short table;
    private final RtProtocol protocol;
    private final short scope;
    private final short type;
    private final long flags;
    private final List<RouteAttribute> attributes;

    private RtNetlink(short addressFamily, int dstLength, int srcLength, short tos, short table, RtProtocol protocol, short scope, short type, long flags, List<RouteAttribute> attributes) {
        this.addressFamily = addressFamily;
        this.dstLength = dstLength;
        this.srcLength = srcLength;
        this.tos = tos;
        this.table = table;
        this.protocol = protocol;
        this.scope = scope;
        this.type = type;
        this.flags = flags;
        this.attributes = ImmutableList.copyOf(attributes);
    }

    public short addressFamily() {
        return this.addressFamily;
    }

    public int dstLength() {
        return this.dstLength;
    }

    public int srcLength() {
        return this.srcLength;
    }

    public short tos() {
        return this.tos;
    }

    public short table() {
        return this.table;
    }

    public RtProtocol protocol() {
        return this.protocol;
    }

    public short scope() {
        return this.scope;
    }

    public short type() {
        return this.type;
    }

    public long flags() {
        return this.flags;
    }

    public List<RouteAttribute> attributes() {
        return this.attributes;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("addressFamily", (int)this.addressFamily).add("dstLength", this.dstLength).add("srcLength", this.srcLength).add("tos", (int)this.tos).add("table", (int)this.table).add("protocol", (Object)this.protocol).add("scope", (int)this.scope).add("type", (int)this.type).add("flags", this.flags).add("attributes", this.attributes).toString();
    }

    public static RtNetlink decode(byte[] buffer, int start, int length) throws DeserializationException {
        PacketUtils.checkInput((byte[])buffer, (int)start, (int)length, (int)12);
        ByteBuffer bb = ByteBuffer.wrap(buffer, start, length);
        short addressFamily = (short)(bb.get() & 0xFF);
        int dstLength = bb.get() & 0xFF;
        int srcLength = bb.get() & 0xFF;
        short tos = (short)(bb.get() & 0xFF);
        short table = (short)(bb.get() & 0xFF);
        short protocol = (short)(bb.get() & 0xFF);
        short scope = (short)(bb.get() & 0xFF);
        short type = (short)(bb.get() & 0xFF);
        long flags = Integer.reverseBytes(bb.getInt());
        ArrayList<RouteAttribute> attributes = new ArrayList<RouteAttribute>();
        RtProtocol rtProtocol = RtProtocol.get(protocol);
        while (bb.hasRemaining()) {
            RouteAttribute attribute = RouteAttribute.decode(buffer, bb.position(), bb.limit() - bb.position());
            attributes.add(attribute);
            bb.position(bb.position() + attribute.length());
        }
        return new RtNetlink(addressFamily, dstLength, srcLength, tos, table, rtProtocol, scope, type, flags, attributes);
    }
}

