/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.PacketUtils;
import org.onosproject.routing.fpm.protocol.RouteAttributeDecoder;
import org.onosproject.routing.fpm.protocol.RouteAttributeDst;
import org.onosproject.routing.fpm.protocol.RouteAttributeGateway;
import org.onosproject.routing.fpm.protocol.RouteAttributeOif;
import org.onosproject.routing.fpm.protocol.RouteAttributePriority;

public abstract class RouteAttribute {
    public static final int ROUTE_ATTRIBUTE_HEADER_LENGTH = 4;
    public static final int RTA_DST = 1;
    public static final int RTA_OIF = 4;
    public static final int RTA_GATEWAY = 5;
    public static final int RTA_PRIORITY = 6;
    private final int length;
    private final int type;
    private static final Map<Integer, RouteAttributeDecoder<?>> TYPE_DECODER_MAP = ImmutableMap.builder().put((Object)1, RouteAttributeDst.decoder()).put((Object)4, RouteAttributeOif.decoder()).put((Object)5, RouteAttributeGateway.decoder()).put((Object)6, RouteAttributePriority.decoder()).build();

    protected RouteAttribute(int length, int type) {
        this.length = length;
        this.type = type;
    }

    public int length() {
        return this.length;
    }

    public int type() {
        return this.type;
    }

    public abstract String toString();

    public static RouteAttribute decode(byte[] buffer, int start, int length) throws DeserializationException {
        PacketUtils.checkInput((byte[])buffer, (int)start, (int)length, (int)4);
        ByteBuffer bb = ByteBuffer.wrap(buffer, start, length);
        short tlvLength = Short.reverseBytes(bb.getShort());
        short type = Short.reverseBytes(bb.getShort());
        if (bb.remaining() < tlvLength - 4) {
            throw new DeserializationException("Incorrect buffer size when decoding route attribute");
        }
        byte[] value = new byte[tlvLength - 4];
        bb.get(value);
        RouteAttributeDecoder<?> decoder = TYPE_DECODER_MAP.get(type);
        if (decoder == null) {
            throw new DeserializationException("No decoder found for route attribute type " + type);
        }
        return decoder.decodeAttribute(tlvLength, type, value);
    }
}

