/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm.protocol;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.PacketUtils;
import org.onosproject.routing.fpm.protocol.Netlink;

public final class FpmHeader {
    public static final int FPM_HEADER_LENGTH = 4;
    public static final short FPM_VERSION_1 = 1;
    public static final short FPM_TYPE_NETLINK = 1;
    private static final String VERSION_NOT_SUPPORTED = "FPM version not supported: ";
    private static final String TYPE_NOT_SUPPORTED = "FPM type not supported: ";
    private final short version;
    private final short type;
    private final int length;
    private final Netlink netlink;

    private FpmHeader(short version, short type, int length, Netlink netlink) {
        this.version = version;
        this.type = type;
        this.length = length;
        this.netlink = netlink;
    }

    public short version() {
        return this.version;
    }

    public short type() {
        return this.type;
    }

    public int length() {
        return this.length;
    }

    public Netlink netlink() {
        return this.netlink;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("version", (int)this.version).add("type", (int)this.type).add("length", this.length).add("netlink", (Object)this.netlink).toString();
    }

    public static FpmHeader decode(byte[] buffer, int start, int length) throws DeserializationException {
        PacketUtils.checkInput((byte[])buffer, (int)start, (int)length, (int)4);
        ByteBuffer bb = ByteBuffer.wrap(buffer, start, length);
        short version = bb.get();
        if (version != 1) {
            throw new DeserializationException(VERSION_NOT_SUPPORTED + version);
        }
        short type = bb.get();
        if (type != 1) {
            throw new DeserializationException(TYPE_NOT_SUPPORTED + type);
        }
        short messageLength = bb.getShort();
        Netlink netlink = Netlink.decode(buffer, bb.position(), bb.limit() - bb.position());
        return new FpmHeader(version, type, messageLength, netlink);
    }
}

