/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.onosproject.routing.fpm.FpmListener;
import org.onosproject.routing.fpm.FpmPeer;
import org.onosproject.routing.fpm.protocol.FpmHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FpmSessionHandler
extends SimpleChannelHandler {
    private static Logger log = LoggerFactory.getLogger(FpmSessionHandler.class);
    private final FpmListener fpmListener;
    private Channel channel;
    private FpmPeer us;

    public FpmSessionHandler(FpmListener fpmListener) {
        this.fpmListener = (FpmListener)Preconditions.checkNotNull((Object)fpmListener);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        FpmHeader fpmMessage = (FpmHeader)e.getMessage();
        this.fpmListener.fpmMessage(this.us, fpmMessage);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        log.error("Exception thrown while handling FPM message", e.getCause());
        if (this.channel != null) {
            this.channel.close();
        }
        this.handleDisconnect();
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        SocketAddress socketAddress = ctx.getChannel().getRemoteAddress();
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalStateException("Address type is not InetSocketAddress");
        }
        this.us = FpmPeer.fromSocketAddress((InetSocketAddress)socketAddress);
        if (!this.fpmListener.peerConnected(this.us)) {
            log.error("Received new FPM connection while already connected");
            ctx.getChannel().close();
            return;
        }
        this.channel = ctx.getChannel();
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.handleDisconnect();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
    }

    private void handleDisconnect() {
        if (this.us != null) {
            this.fpmListener.peerDisconnected(this.us);
        }
        this.channel = null;
    }
}

