/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm;

import com.google.common.base.MoreObjects;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.onlab.packet.IpAddress;

public class FpmPeer {
    private final IpAddress address;
    private final int port;

    public FpmPeer(IpAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    public IpAddress address() {
        return this.address;
    }

    public int port() {
        return this.port;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.port);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FpmPeer)) {
            return false;
        }
        FpmPeer that = (FpmPeer)other;
        return Objects.equals(this.address, that.address) && Objects.equals(this.port, that.port);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("port", this.port).toString();
    }

    public static FpmPeer fromSocketAddress(InetSocketAddress address) {
        return new FpmPeer(IpAddress.valueOf((InetAddress)address.getAddress()), address.getPort());
    }
}

