/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.routing.fpm;

import com.google.common.collect.ImmutableMap;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.util.Tools;
import org.onosproject.cfg.ComponentConfigService;
import org.onosproject.incubator.net.routing.Route;
import org.onosproject.incubator.net.routing.RouteAdminService;
import org.onosproject.routing.fpm.FpmFrameDecoder;
import org.onosproject.routing.fpm.FpmInfoService;
import org.onosproject.routing.fpm.FpmListener;
import org.onosproject.routing.fpm.FpmPeer;
import org.onosproject.routing.fpm.FpmSessionHandler;
import org.onosproject.routing.fpm.protocol.FpmHeader;
import org.onosproject.routing.fpm.protocol.Netlink;
import org.onosproject.routing.fpm.protocol.RouteAttribute;
import org.onosproject.routing.fpm.protocol.RouteAttributeDst;
import org.onosproject.routing.fpm.protocol.RouteAttributeGateway;
import org.onosproject.routing.fpm.protocol.RtNetlink;
import org.onosproject.routing.fpm.protocol.RtProtocol;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
@Component(immediate=true)
public class FpmManager
implements FpmInfoService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int FPM_PORT = 2620;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ComponentConfigService componentConfigService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouteAdminService routeService;
    private ServerBootstrap serverBootstrap;
    private Channel serverChannel;
    private ChannelGroup allChannels = new DefaultChannelGroup();
    private Map<FpmPeer, Long> peers = new ConcurrentHashMap<FpmPeer, Long>();
    private Map<FpmPeer, Map<IpPrefix, Route>> fpmRoutes = new ConcurrentHashMap<FpmPeer, Map<IpPrefix, Route>>();
    @Property(name="clearRoutes", boolValue={true}, label="Whether to clear routes when the FPM connection goes down")
    private boolean clearRoutes = true;

    @Activate
    protected void activate(ComponentContext context) {
        this.componentConfigService.preSetProperty("org.onosproject.incubator.store.routing.impl.RouteStoreImpl", "distributed", "true");
        this.componentConfigService.registerProperties(this.getClass());
        this.modified(context);
        this.startServer();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.componentConfigService.preSetProperty("org.onosproject.incubator.store.routing.impl.RouteStoreImpl", "distributed", "false");
        this.stopServer();
        this.fpmRoutes.clear();
        this.componentConfigService.unregisterProperties(this.getClass(), false);
        this.log.info("Stopped");
    }

    @Modified
    protected void modified(ComponentContext context) {
        Dictionary properties = context.getProperties();
        if (properties == null) {
            return;
        }
        String strClearRoutes = Tools.get((Dictionary)properties, (String)"clearRoutes");
        this.clearRoutes = Boolean.parseBoolean(strClearRoutes);
        this.log.info("clearRoutes set to {}", (Object)this.clearRoutes);
    }

    private void startServer() {
        NioServerSocketChannelFactory channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/fpm", (String)"sm-boss-%d", (Logger)this.log)), (Executor)Executors.newCachedThreadPool(Tools.groupedThreads((String)"onos/fpm", (String)"sm-worker-%d", (Logger)this.log)));
        ChannelPipelineFactory pipelineFactory = () -> {
            FpmSessionHandler fpmSessionHandler = new FpmSessionHandler(new InternalFpmListener());
            FpmFrameDecoder fpmFrameDecoder = new FpmFrameDecoder();
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("FpmFrameDecoder", (ChannelHandler)fpmFrameDecoder);
            pipeline.addLast("FpmSession", (ChannelHandler)fpmSessionHandler);
            return pipeline;
        };
        InetSocketAddress listenAddress = new InetSocketAddress(2620);
        this.serverBootstrap = new ServerBootstrap((ChannelFactory)channelFactory);
        this.serverBootstrap.setOption("child.reuseAddr", (Object)true);
        this.serverBootstrap.setOption("child.keepAlive", (Object)true);
        this.serverBootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.serverBootstrap.setPipelineFactory(pipelineFactory);
        try {
            this.serverChannel = this.serverBootstrap.bind((SocketAddress)listenAddress);
            this.allChannels.add((Object)this.serverChannel);
        }
        catch (ChannelException e) {
            this.log.debug("Exception binding to FPM port {}: ", (Object)listenAddress.getPort(), (Object)e);
            this.stopServer();
        }
    }

    private void stopServer() {
        this.allChannels.close().awaitUninterruptibly();
        this.allChannels.clear();
        if (this.serverBootstrap != null) {
            this.serverBootstrap.releaseExternalResources();
        }
        if (this.clearRoutes) {
            this.peers.keySet().forEach(this::clearRoutes);
        }
    }

    private void fpmMessage(FpmPeer peer, FpmHeader fpmMessage) {
        Netlink netlink = fpmMessage.netlink();
        RtNetlink rtNetlink = netlink.rtNetlink();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received FPM message: {}", (Object)fpmMessage);
        }
        if (rtNetlink.protocol() != RtProtocol.ZEBRA && rtNetlink.protocol() != RtProtocol.UNSPEC) {
            this.log.trace("Ignoring non-zebra route");
            return;
        }
        IpAddress dstAddress = null;
        IpAddress gateway = null;
        for (RouteAttribute attribute : rtNetlink.attributes()) {
            if (attribute.type() == 1) {
                RouteAttributeDst raDst = (RouteAttributeDst)attribute;
                dstAddress = raDst.dstAddress();
                continue;
            }
            if (attribute.type() != 5) continue;
            RouteAttributeGateway raGateway = (RouteAttributeGateway)attribute;
            gateway = raGateway.gateway();
        }
        if (dstAddress == null) {
            this.log.error("Dst address missing!");
            return;
        }
        IpPrefix prefix = IpPrefix.valueOf(dstAddress, (int)rtNetlink.dstLength());
        LinkedList<Route> updates = new LinkedList<Route>();
        LinkedList<Route> withdraws = new LinkedList<Route>();
        switch (netlink.type()) {
            case RTM_NEWROUTE: {
                if (gateway == null) {
                    return;
                }
                Route route = new Route(Route.Source.FPM, prefix, gateway);
                Route oldRoute = this.fpmRoutes.get(peer).put(prefix, route);
                if (oldRoute != null) {
                    this.log.trace("Swapping {} with {}", (Object)oldRoute, (Object)route);
                    withdraws.add(oldRoute);
                }
                updates.add(route);
                break;
            }
            case RTM_DELROUTE: {
                Route existing = this.fpmRoutes.get(peer).remove(prefix);
                if (existing == null) {
                    this.log.warn("Got delete for non-existent prefix");
                    return;
                }
                Route route = new Route(Route.Source.FPM, prefix, existing.nextHop());
                withdraws.add(route);
                break;
            }
        }
        this.routeService.withdraw(withdraws);
        this.routeService.update(updates);
    }

    private void clearRoutes(FpmPeer peer) {
        this.log.info("Clearing all routes for peer {}", (Object)peer);
        Map<IpPrefix, Route> routes = this.fpmRoutes.remove(peer);
        if (routes != null) {
            this.routeService.withdraw(routes.values());
        }
    }

    @Override
    public Map<FpmPeer, Long> peers() {
        return ImmutableMap.copyOf(this.peers);
    }

    protected void bindComponentConfigService(ComponentConfigService componentConfigService) {
        this.componentConfigService = componentConfigService;
    }

    protected void unbindComponentConfigService(ComponentConfigService componentConfigService) {
        if (this.componentConfigService == componentConfigService) {
            this.componentConfigService = null;
        }
    }

    protected void bindRouteService(RouteAdminService routeAdminService) {
        this.routeService = routeAdminService;
    }

    protected void unbindRouteService(RouteAdminService routeAdminService) {
        if (this.routeService == routeAdminService) {
            this.routeService = null;
        }
    }

    private class InternalFpmListener
    implements FpmListener {
        private InternalFpmListener() {
        }

        @Override
        public void fpmMessage(FpmPeer peer, FpmHeader fpmMessage) {
            FpmManager.this.fpmMessage(peer, fpmMessage);
        }

        @Override
        public boolean peerConnected(FpmPeer peer) {
            if (FpmManager.this.peers.keySet().contains(peer)) {
                return false;
            }
            FpmManager.this.peers.put(peer, System.currentTimeMillis());
            FpmManager.this.fpmRoutes.computeIfAbsent(peer, p -> new ConcurrentHashMap());
            return true;
        }

        @Override
        public void peerDisconnected(FpmPeer peer) {
            FpmManager.this.log.info("FPM connection to {} went down", (Object)peer);
            if (FpmManager.this.clearRoutes) {
                FpmManager.this.clearRoutes(peer);
            }
            FpmManager.this.peers.remove(peer);
        }
    }
}

