/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public final class LispSourceDestLcafAddress
extends LispLcafAddress {
    private final LispAfiAddress srcPrefix;
    private final LispAfiAddress dstPrefix;
    private final byte srcMaskLength;
    private final byte dstMaskLength;
    private final short reserved;

    private LispSourceDestLcafAddress(short reserved, byte srcMaskLength, byte dstMaskLength, LispAfiAddress srcPrefix, LispAfiAddress dstPrefix) {
        super(LispCanonicalAddressFormatEnum.SOURCE_DEST);
        this.reserved = reserved;
        this.srcMaskLength = srcMaskLength;
        this.dstMaskLength = dstMaskLength;
        this.srcPrefix = srcPrefix;
        this.dstPrefix = dstPrefix;
    }

    private LispSourceDestLcafAddress(byte reserved1, byte reserved2, byte flag, short length, short reserved, byte srcMaskLength, byte dstMaskLength, LispAfiAddress srcPrefix, LispAfiAddress dstPrefix) {
        super(LispCanonicalAddressFormatEnum.SOURCE_DEST, reserved1, reserved2, flag, length);
        this.reserved = reserved;
        this.srcMaskLength = srcMaskLength;
        this.dstMaskLength = dstMaskLength;
        this.srcPrefix = srcPrefix;
        this.dstPrefix = dstPrefix;
    }

    public LispAfiAddress getSrcPrefix() {
        return this.srcPrefix;
    }

    public LispAfiAddress getDstPrefix() {
        return this.dstPrefix;
    }

    public byte getSrcMaskLength() {
        return this.srcMaskLength;
    }

    public byte getDstMaskLength() {
        return this.dstMaskLength;
    }

    public short getReserved() {
        return this.reserved;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.srcPrefix, this.dstPrefix, this.srcMaskLength, this.dstMaskLength, this.reserved);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispSourceDestLcafAddress) {
            LispSourceDestLcafAddress other = (LispSourceDestLcafAddress)obj;
            return Objects.equals(this.srcPrefix, other.srcPrefix) && Objects.equals(this.dstPrefix, other.dstPrefix) && Objects.equals(this.srcMaskLength, other.srcMaskLength) && Objects.equals(this.dstMaskLength, other.dstMaskLength) && Objects.equals(this.reserved, other.reserved);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source prefix", (Object)this.srcPrefix).add("destination prefix", (Object)this.dstPrefix).add("source mask length", (int)this.srcMaskLength).add("destination mask length", (int)this.dstMaskLength).add("reserved", (int)this.reserved).toString();
    }

    public static class SourceDestLcafAddressWriter
    implements LispAddressWriter<LispSourceDestLcafAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispSourceDestLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            byteBuf.writeShort((int)address.getReserved());
            byteBuf.writeByte((int)address.getSrcMaskLength());
            byteBuf.writeByte((int)address.getDstMaskLength());
            LispAfiAddress.AfiAddressWriter writer = new LispAfiAddress.AfiAddressWriter();
            writer.writeTo(byteBuf, address.getSrcPrefix());
            writer.writeTo(byteBuf, address.getDstPrefix());
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class SourceDestLcafAddressReader
    implements LispAddressReader<LispSourceDestLcafAddress> {
        @Override
        public LispSourceDestLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress.deserializeCommon(byteBuf);
            short reserved = byteBuf.readShort();
            byte srcMaskLength = (byte)byteBuf.readUnsignedByte();
            byte dstMaskLength = (byte)byteBuf.readUnsignedByte();
            LispAfiAddress srcPrefix = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            LispAfiAddress dstPrefix = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new SourceDestAddressBuilder().withReserved(reserved).withSrcMaskLength(srcMaskLength).withDstMaskLength(dstMaskLength).withSrcPrefix(srcPrefix).withDstPrefix(dstPrefix).build();
        }
    }

    public static final class SourceDestAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<SourceDestAddressBuilder> {
        private LispAfiAddress srcPrefix;
        private LispAfiAddress dstPrefix;
        private byte srcMaskLength;
        private byte dstMaskLength;
        private short reserved;

        public SourceDestAddressBuilder withSrcPrefix(LispAfiAddress srcPrefix) {
            this.srcPrefix = srcPrefix;
            return this;
        }

        public SourceDestAddressBuilder withDstPrefix(LispAfiAddress dstPrefix) {
            this.dstPrefix = dstPrefix;
            return this;
        }

        public SourceDestAddressBuilder withSrcMaskLength(byte srcMaskLength) {
            this.srcMaskLength = srcMaskLength;
            return this;
        }

        public SourceDestAddressBuilder withDstMaskLength(byte dstMaskLength) {
            this.dstMaskLength = dstMaskLength;
            return this;
        }

        public SourceDestAddressBuilder withReserved(short reserved) {
            this.reserved = reserved;
            return this;
        }

        @Override
        public LispSourceDestLcafAddress build() {
            Preconditions.checkNotNull((Object)this.srcPrefix, (Object)"Must specify a source address prefix");
            Preconditions.checkNotNull((Object)this.dstPrefix, (Object)"Must specify a destination address prefix");
            return new LispSourceDestLcafAddress(this.reserved1, this.reserved2, this.flag, this.length, this.reserved, this.srcMaskLength, this.dstMaskLength, this.srcPrefix, this.dstPrefix);
        }
    }
}

